/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.util;

import com.bxm.adsprod.common.utils.IpUtils;
import com.bxm.adsprod.dal.activity.AdTicketIpMapper;
import com.bxm.adsprod.dal.entity.AdTicketIpDO;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class DownloadUtil {
    public static void downLoadFromUrl(String urlStr, String fileName, String savePath) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        byte[] getData = DownloadUtil.readInputStream(inputStream);
        File saveDir = new File(savePath);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        File file = new File(saveDir + File.separator + fileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(getData);
        if (fos != null) {
            fos.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        System.out.println("info:" + url + " download success");
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static void read(AdTicketIpMapper adTicketIpMapper) throws IOException {
        String savePath = "E:\\bigdata2";
        String fileName = "heiniu.txt";
        InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(savePath + File.separator + fileName), "UTF-8");
        BufferedReader bufReader = new BufferedReader(inReader);
        String line = null;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        while ((line = bufReader.readLine()) != null) {
            String[] split = line.split("-");
            if (split.length != 2) continue;
            int startIp = IpUtils.getIntIp((String)split[0]);
            int endIp = IpUtils.getIntIp((String)split[1]);
            if (startIp == 0 || endIp == 0 || startIp >= endIp) continue;
            map.put(startIp, endIp);
        }
        bufReader.close();
        inReader.close();
        Integer startIp = 0;
        Integer endIp = 0;
        AdTicketIpDO ap = new AdTicketIpDO();
        for (Map.Entry entry : map.entrySet()) {
            Integer startIp2 = (Integer)entry.getKey();
            Integer endIp2 = (Integer)entry.getValue();
            ap.setIpLibrary(Integer.valueOf(1));
            Date nowDate = new Date();
            ap.setCreateTime(nowDate);
            ap.setModifiedTime(nowDate);
            if (startIp2 <= endIp) {
                ap.setStartIp(startIp);
                ap.setEndIp(endIp2);
                adTicketIpMapper.updateById(ap);
            } else {
                ap.setStartIp(startIp2);
                ap.setEndIp(endIp2);
                adTicketIpMapper.save(ap);
                System.out.println(startIp2 + "" + endIp2);
                startIp = startIp2;
            }
            endIp = endIp2;
        }
    }
}

