/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.integration.message.MessageBody;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageListener
implements SingleMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageListener.class);

    protected abstract void consume(Message var1, Object var2, Object var3);

    @Override
    public ConsumeStatus consume(Message message, Object context) {
        try {
            Object returning;
            MessageBody body = JsonHelper.convert(message.getBody(), MessageBody.class);
            if (null == body) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not consume message {}-{}, because body cannot deserialize.", (Object)message.getTopic(), (Object)message.getMsgId());
                }
                return ConsumeStatus.RECONSUME_LATER;
            }
            Object request = body.getRequest();
            if (null != request && request instanceof JSON) {
                request = JSONObject.toJavaObject((JSON)((JSON)request), body.getRequestClass());
            }
            if (null != (returning = body.getReturning()) && returning instanceof JSON) {
                returning = JSONObject.toJavaObject((JSON)((JSON)body.getReturning()), body.getReturningClass());
            }
            this.consume(message, request, returning);
            return ConsumeStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("consume: ", (Throwable)e);
            }
            return ConsumeStatus.RECONSUME_LATER;
        }
    }
}

