/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.pushable;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.LifeCycle;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CachePushableBus
extends LifeCycle
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableBus.class);
    private ApplicationContext ctx;
    private final Map<String, Pushable> pushables = new HashMap<String, Pushable>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
        this.init();
    }

    @Override
    protected void doInit() {
        Map beans = this.ctx.getBeansOfType(Pushable.class);
        for (Map.Entry entry : beans.entrySet()) {
            Pushable bean = (Pushable)entry.getValue();
            CachePush anno = bean.getClass().getAnnotation(CachePush.class);
            if (null == anno) continue;
            this.pushables.put(anno.value(), bean);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Registering bean to CachePushableBus: {}", (Object)bean);
        }
    }

    @Override
    protected void doDestroy() {
    }

    public Pushable getRefreshable(String serviceName) {
        if (!this.isInitialized()) {
            throw new RuntimeException("RefreshBus must be initialized.");
        }
        return this.pushables.get(serviceName);
    }
}

