/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.kafka;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.kafka.KafkaMsgIdUtils;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class KafkaConsumer
extends LifeCycle
implements Consumer {
    private final Listener listener;
    private int consumeTimeOutInMillis = 100;
    private org.apache.kafka.clients.consumer.Consumer<String, byte[]> consumer;

    public KafkaConsumer(Properties properties, Listener listener) {
        this.listener = listener;
        this.consumer = new org.apache.kafka.clients.consumer.KafkaConsumer(properties);
    }

    @Override
    protected void doInit() {
        String topic = this.getMessageListener().getTopic();
        this.consumer.subscribe((Collection)Lists.newArrayList((Object[])new String[]{topic}));
        block3: while (true) {
            ConsumerRecords records = this.consumer.poll((long)this.consumeTimeOutInMillis);
            Iterator iterator = records.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                byte[] value = (byte[])record.value();
                Message message = new Message();
                message.setBody(value);
                message.setKey((String)record.key());
                message.setMsgId(KafkaMsgIdUtils.generate(record.topic(), record.partition(), record.offset()));
                Enum status = null;
                if (this.listener instanceof SingleMessageListener) {
                    status = ((SingleMessageListener)this.listener).consume(message, null);
                }
                if (null == status) continue;
                switch (1.$SwitchMap$com$bxm$warcar$mq$ConsumeStatus[status.ordinal()]) {
                    case 1: {
                        this.consumer.commitAsync();
                        break;
                    }
                }
            }
            break;
        }
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        if (null != this.consumer) {
            this.consumer.close();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public Listener getMessageListener() {
        return this.listener;
    }

    public int getConsumeTimeOutInMillis() {
        return this.consumeTimeOutInMillis;
    }

    public void setConsumeTimeOutInMillis(int consumeTimeOutInMillis) {
        this.consumeTimeOutInMillis = consumeTimeOutInMillis;
    }
}

