/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class StringHelper
extends StringUtils {
    public static final char[] CODE_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static String random(char[] scope, int len) {
        if (ArrayUtils.isEmpty((char[])scope)) {
            scope = CODE_ARRAY;
        }
        StringBuilder str = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            str.append(scope[RandomUtils.nextInt((int)scope.length)]);
        }
        return str.toString();
    }

    public static String random(int len) {
        return StringHelper.random(CODE_ARRAY, len);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    }

    public static String randomInt(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(RandomUtils.nextInt((int)10));
        }
        return sb.toString();
    }

    public static String convert(byte[] b) {
        if (ArrayUtils.isEmpty((byte[])b)) {
            return null;
        }
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(b);
        }
    }

    public static byte[] convert(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string.getBytes();
        }
    }

    public static String unicode2native(String str) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92) {
                if ((aChar = str.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

