/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.config;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.adsprod.third.config.OssConfiguration;
import com.bxm.warcar.utils.DateHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Configuration
@EnableConfigurationProperties(value={OssConfiguration.class})
public class UploadHelper {
    private static final String IMGFILEHOST = "https://m.cudaojia.com/";
    private static final String BUCKETNAME = "bxm-guide";
    private OssConfiguration configuration;

    public UploadHelper(OssConfiguration config) {
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object uploadImg(HttpServletRequest request, String path) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> files = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null) continue;
                String fileName = file.getOriginalFilename();
                String suffixNmae = fileName.substring(fileName.indexOf("."));
                if (!StringUtils.isNotBlank((CharSequence)fileName.trim())) continue;
                File newFile = new File(request.getSession().getServletContext().getRealPath("/") + fileName);
                try {
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    file.transferTo(newFile);
                    String fileUrl = "dist/" + path + "/" + DateHelper.format((String)"yyyyMMddHHmmss") + RandomUtils.nextInt() + suffixNmae;
                    files.add(this.upload(newFile, BUCKETNAME, IMGFILEHOST, fileUrl));
                }
                finally {
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                }
            }
        }
        String rs = "[";
        for (String url : files) {
            rs = rs + "{\"url\":\"" + url + "\"}";
        }
        rs = rs + "]";
        return JSON.parse((String)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upload(File file, String bucketName, String imgFileHost, String fileUrl) throws ClientException {
        if (file == null) {
            return null;
        }
        OSSClient ossClient = new OSSClient(this.configuration.getEndPoint(), this.configuration.getAccessKeyId(), this.configuration.getAccessKeySecret());
        try {
            PutObjectResult result;
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            if (null != (result = ossClient.putObject(new PutObjectRequest(bucketName, fileUrl, file)))) {
                String string = imgFileHost + fileUrl;
                return string;
            }
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }
}

