/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.controller;

import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.controller.BaseController;
import com.bxm.adsprod.third.model.HeiNiuSubmitRsp;
import com.bxm.adsprod.third.model.LandUserInfo;
import com.bxm.adsprod.third.model.LandVo;
import com.bxm.adsprod.third.model.Result;
import com.bxm.adsprod.third.model.land.BaseLandUserParamsDto;
import com.bxm.adsprod.third.model.land.LandUserActionResultVo;
import com.bxm.adsprod.third.service.LandService;
import com.bxm.adsprod.third.util.IpUtils;
import com.google.common.base.Preconditions;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/land"})
public class LandController
extends BaseController {
    @Autowired
    private LandService landService;

    @RequestMapping(value={"/getHeiNiuLandInfo"}, method={RequestMethod.GET})
    public Result<LandVo> getHeiNiuLandInfo(String channel, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            String ip = IpUtils.getRemoteIp(request);
            if (StringUtils.isBlank((CharSequence)ip)) {
                return this.failResult(ErrorCode.E0100000);
            }
            return this.successResult(this.landService.getHeiNiuLandInfo(channel, ip));
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @RequestMapping(value={"/smsVerifyCode"}, method={RequestMethod.GET})
    public Result<Boolean> smsVerifyCode(String channel, String userPhone, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            Preconditions.checkNotNull((Object)channel, (Object)"\u53c2\u6570[channel]\u4e0d\u5b58\u5728");
            Preconditions.checkNotNull((Object)userPhone, (Object)"\u53c2\u6570[userPhone]\u4e0d\u5b58\u5728");
            String ip = IpUtils.getRemoteIp(request);
            if (StringUtils.isBlank((CharSequence)ip)) {
                return this.failResult(ErrorCode.E0100000);
            }
            return this.successResult(this.landService.smsVerifyCode(channel, userPhone, ip));
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.GET, RequestMethod.POST})
    public Result<HeiNiuSubmitRsp> submit(LandUserInfo landUserInfo, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            Preconditions.checkNotNull((Object)landUserInfo.getOrderId(), (Object)"\u53c2\u6570[orderId]\u4e0d\u5b58\u5728");
            Preconditions.checkNotNull((Object)landUserInfo.getVerifyCode(), (Object)"\u53c2\u6570[verifyCode]\u4e0d\u5b58\u5728");
            String ip = IpUtils.getRemoteIp(request);
            String ua = request.getHeader("User-Agent");
            if (StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)ua)) {
                return this.failResult(ErrorCode.E0100000);
            }
            return this.successResult(this.landService.submit(landUserInfo, ip, ua));
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @RequestMapping(value={"/setCache"}, method={RequestMethod.GET, RequestMethod.POST})
    public Result<Boolean> setCache(String id) {
        try {
            return this.successResult(this.landService.setIpDefined(id));
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @RequestMapping(value={"/tencentnews/submit"}, method={RequestMethod.GET, RequestMethod.POST})
    public Result<LandUserActionResultVo> submitInfo(String paramsJson, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            String ip = IpUtils.getRemoteIp(request);
            String ua = request.getHeader("User-Agent");
            if (StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)ua)) {
                return this.failResult(ErrorCode.E0100000);
            }
            return this.successResult(this.landService.submitInfo(new BaseLandUserParamsDto(ip, ua, "TENCENT_NEWS", paramsJson)));
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }
}

