/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.service;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.dal.activity.LandUserInfoMapper;
import com.bxm.adsprod.dal.entity.LandUserInfoDO;
import com.bxm.adsprod.facade.activity.ActivityKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.constant.LandChannel;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.HeiNiuLandVo;
import com.bxm.adsprod.third.model.HeiNiuSubmitRsp;
import com.bxm.adsprod.third.model.LandUserInfo;
import com.bxm.adsprod.third.model.land.BaseLandUserParamsDto;
import com.bxm.adsprod.third.model.land.LandUserActionResultVo;
import com.bxm.adsprod.third.model.third.HeiNiuInfo;
import com.bxm.adsprod.third.service.BaseService;
import com.bxm.adsprod.third.service.core.LandUserOperationService;
import com.bxm.adsprod.third.util.MathUtil;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LandService
extends BaseService
implements InitializingBean {
    @Autowired
    private LandUserInfoMapper landUserInfoMapper;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Value(value="${heiniu.domain}")
    private String heiNiuDomain;
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;
    @Autowired
    private List<LandUserOperationService> landUserOperationServices;
    private static Map<String, LandUserOperationService> landUserOperationServiceMap;

    public void afterPropertiesSet() throws Exception {
        landUserOperationServiceMap = new HashMap<String, LandUserOperationService>(this.landUserOperationServices.size());
        for (LandUserOperationService landUserAction : this.landUserOperationServices) {
            landUserOperationServiceMap.put(landUserAction.getActionCode(), landUserAction);
        }
    }

    public HeiNiuLandVo getHeiNiuLandInfo(String channel, String ip) throws ThirdException {
        HeiNiuLandVo rsp = new HeiNiuLandVo();
        rsp.setId(LandChannel.HEINIU.getChannel());
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("token", "6d32aa19-749c-11e8-8e99-dca90487e6d2");
        param.put("ip", ip);
        try {
            param.put("callback_url", URLEncoder.encode("http://m.cudaojia.com?appKey=468f8023e69b42b58ddfa2a54611fd1d&appType=h5&appEntrance=3&business=money", "UTF-8"));
            Connection.Response response = Jsoup.connect((String)(this.heiNiuDomain + "/api/bianxianmao/policy/display")).data(param).ignoreContentType(true).method(Connection.Method.POST).execute();
            if (null != response) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.body());
                String policyCode = jsonObject.getString("policy_postfix");
                if (StringUtils.isBlank((String)policyCode)) {
                    throw new ThirdException(ErrorCode.E0100005.getCode(), "\u9ed1\u725b\u7d20\u6750\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
                }
                rsp.setValidity(jsonObject.getString("policy_validity"));
                rsp.setPolicyCode(jsonObject.getString("policy_postfix"));
                rsp.setAgeRange(jsonObject.getString("policy_age_range"));
                rsp.setTitle(jsonObject.getString("policy_name"));
                rsp.setIsDdh(jsonObject.getBooleanValue("is_ddh"));
                List infos = jsonObject.getJSONArray("policy_infos").toJavaList(HeiNiuInfo.class);
                rsp.setDetail(infos);
            }
        }
        catch (IOException e) {
            this.logger.error("LandService.getHeiNiuLandInfo request heiniu fail,reason={}", (Throwable)e);
            throw new ThirdException(e);
        }
        return rsp;
    }

    public boolean smsVerifyCode(String channel, String userPhone, String ip) throws ThirdException {
        TreeMap<String, String> map;
        KeyGenerator keyGenerator = ActivityKeyGenerator.User.getUserSmsRecord((String)userPhone);
        Map cache = this.fetcher.hfetchall(keyGenerator, String.class);
        long now = System.currentTimeMillis();
        if (MapUtils.isEmpty((Map)cache)) {
            map = new TreeMap<String, String>();
        } else {
            map = new TreeMap(cache);
            int size = map.size();
            long s = now;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                s = Long.parseLong((String)iterator.next());
            }
            if (now - s <= 60000L) {
                throw new ThirdException(ErrorCode.E0100001);
            }
            if (size >= 3) {
                throw new ThirdException(ErrorCode.E0100002);
            }
        }
        String code = MathUtil.createRandom(6);
        if (LandChannel.HEINIU.getChannel().equals(channel)) {
            HashMap<String, String> param = new HashMap<String, String>(4);
            param.put("token", "6d32aa19-749c-11e8-8e99-dca90487e6d2");
            param.put("ip", ip);
            param.put("mobile", userPhone);
            param.put("captcha", code);
            try {
                JSONObject jsonObject;
                String errorCode;
                Connection.Response response = Jsoup.connect((String)(this.heiNiuDomain + "/api/bianxianmao/captcha/sender")).data(param).ignoreContentType(true).method(Connection.Method.POST).execute();
                if (null != response && StringUtils.equals((String)"0", (String)(errorCode = (jsonObject = JSONObject.parseObject((String)response.body())).getString("error_code")))) {
                    throw new ThirdException(ErrorCode.E0100005.getCode(), jsonObject.getString("error_msg"));
                }
            }
            catch (Exception e) {
                this.logger.error("LandService.smsVerifyCode request heiniu fail,reason={}", (Throwable)e);
                throw new ThirdException(e);
            }
        }
        map.put(String.valueOf(now), code);
        this.updater.hmupdate(keyGenerator, map, map.size() == 1 ? 86400 : 0);
        return true;
    }

    public HeiNiuSubmitRsp submit(LandUserInfo landUserInfo, String ip, String ua) throws ThirdException {
        this.verifyCode(landUserInfo);
        this.saveUserInfo(landUserInfo);
        HeiNiuSubmitRsp rsp = new HeiNiuSubmitRsp();
        HashMap<String, String> param = new HashMap<String, String>(7);
        param.put("token", "6d32aa19-749c-11e8-8e99-dca90487e6d2");
        param.put("ip", ip);
        param.put("id_card", landUserInfo.getIdentification());
        param.put("name", landUserInfo.getUserName());
        param.put("mobile", landUserInfo.getUserPhone());
        param.put("policy_code", landUserInfo.getPolicyCode());
        param.put("user_agent", ua);
        try {
            Connection.Response response = Jsoup.connect((String)(this.heiNiuDomain + "/api/bianxianmao/policy/submit")).data(param).ignoreContentType(true).method(Connection.Method.POST).execute();
            if (null != response) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.body());
                String callbackUrl = jsonObject.getString("callback_url");
                if (StringUtils.isBlank((String)callbackUrl)) {
                    throw new ThirdException(ErrorCode.E0100005.getCode(), "\u9ed1\u725b\u63d0\u4ea4\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
                }
                rsp.setCallbackUrl(callbackUrl);
                rsp.setCouponUrl(jsonObject.getString("coupon_url"));
            }
        }
        catch (Exception e) {
            this.logger.error("LandService.submit request heiniu fail,reason={}", (Throwable)e);
            throw new ThirdException(e);
        }
        return rsp;
    }

    private void verifyCode(LandUserInfo landUserInfo) throws ThirdException {
        KeyGenerator keyGenerator = ActivityKeyGenerator.User.getUserSmsRecord((String)landUserInfo.getUserPhone());
        Map cache = this.fetcher.hfetchall(keyGenerator, String.class);
        if (MapUtils.isEmpty((Map)cache)) {
            throw new ThirdException(ErrorCode.E0100004);
        }
        TreeMap map = new TreeMap(cache);
        Map.Entry last2 = null;
        for (Map.Entry last2 : map.entrySet()) {
        }
        long now = System.currentTimeMillis();
        if (!((String)last2.getValue()).equals(landUserInfo.getVerifyCode())) {
            throw new ThirdException(ErrorCode.E0100003);
        }
        if (now - Long.valueOf((String)last2.getKey()) >= 300000L) {
            throw new ThirdException(ErrorCode.E0100004);
        }
    }

    private void saveUserInfo(LandUserInfo landUserInfo) {
        try {
            String result = (String)this.jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"clickMsg", landUserInfo.getOrderId()}), String.class, 11);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("\u9ed1\u725b\u843d\u5730\u9875\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1aresult={},orderId={}", (Object)result, (Object)landUserInfo.getOrderId());
                return;
            }
            String[] results = result.split(":");
            if (results.length < 6) {
                this.logger.error("\u9ed1\u725b\u843d\u5730\u9875\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u4e0d\u5168\uff1aresult={},orderId={}", (Object)results, (Object)landUserInfo.getOrderId());
                return;
            }
            LandUserInfoDO landUserInfoDO = new LandUserInfoDO();
            landUserInfoDO.setActivityId(Long.valueOf(Long.parseLong(results[3])));
            landUserInfoDO.setAppkey(results[1]);
            landUserInfoDO.setChannel(LandChannel.HEINIU.getChannel());
            landUserInfoDO.setIdentification(landUserInfo.getIdentification());
            landUserInfoDO.setOrderId(landUserInfo.getOrderId());
            landUserInfoDO.setUserName(landUserInfo.getUserName());
            landUserInfoDO.setUserPhone(landUserInfo.getUserPhone());
            landUserInfoDO.setTicketId(Long.valueOf(Long.parseLong(results[4])));
            landUserInfoDO.setUid(results[5]);
            landUserInfoDO.setBusiness(results[2]);
            this.landUserInfoMapper.save(landUserInfoDO);
        }
        catch (Exception e) {
            this.logger.error("LandService.submit save userInfo fail,reason={}", (Throwable)e);
        }
    }

    public boolean setIpDefined(String ticketId) {
        KeyGenerator keyGenerator = TicketKeyGenerator.Filter.getIpLibraryDefined();
        HashSet<String> items = (HashSet<String>)this.fetcher.hfetch(keyGenerator, "1", Set.class);
        if (CollectionUtils.isEmpty((Collection)items)) {
            items = new HashSet<String>();
        }
        items.add(ticketId);
        this.updater.hupdate(keyGenerator, "1", items);
        return true;
    }

    public LandUserActionResultVo submitInfo(BaseLandUserParamsDto baseLandUserParamsDto) throws ThirdException {
        LandUserOperationService landUserAction = landUserOperationServiceMap.get(baseLandUserParamsDto.getActionCode());
        if (null == landUserAction) {
            throw new ThirdException(ErrorCode.E9999999.getCode(), "\u672a\u67e5\u8be2\u5230\u5904\u7406\u7c7b\uff01");
        }
        this.logger.info("==============\u8bf7\u6c42\u53c2\u6570\uff1a" + baseLandUserParamsDto.getParamsJson());
        return landUserAction.doOperation(baseLandUserParamsDto);
    }
}

