/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.common.utils.IpUtils;
import com.bxm.adsprod.dal.activity.AdTicketIpMapper;
import com.bxm.adsprod.dal.activity.LandInterfaceMapper;
import com.bxm.adsprod.dal.entity.AdTicketIpDO;
import com.bxm.adsprod.dal.entity.LandInterfaceDO;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.constant.LandChannel;
import com.bxm.adsprod.model.constant.UpdateType;
import com.bxm.adsprod.model.dto.AdTicketIpDto;
import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.third.HeiNiuIp;
import com.bxm.adsprod.third.model.third.HeiNiuResult;
import com.bxm.adsprod.third.service.BaseService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThirdService
extends BaseService {
    @Autowired
    private AdTicketIpMapper adTicketIpMapper;
    @Autowired
    private LandInterfaceMapper landInterfaceMapper;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Value(value="${heiniu.domain}")
    private String heiNiuDomain;
    @Value(value="${click.domain}")
    private String clickDomain;
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;

    public boolean updateIpLibrary(String channel, String urlStr, Integer updateType, Integer updateAll, String token) throws IOException, ThirdException {
        this.checkToken(token);
        int channelId = LandChannel.getLandChannel((String)channel).getId();
        if (LandChannel.HEINIU.getChannel().equals(channel)) {
            Map<Integer, Integer> map;
            if (StringUtils.isBlank((String)urlStr)) {
                StringBuilder sb = new StringBuilder(this.heiNiuDomain);
                sb.append("/api/bianxianmao/ip_range").append("?").append("token=").append("6d32aa19-749c-11e8-8e99-dca90487e6d2");
                urlStr = sb.toString();
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            if (UpdateType.BY_TXT.getValue().equals(updateType)) {
                map = this.sort4Txt(conn);
            } else if (UpdateType.BY_RESPONSE.getValue().equals(updateType)) {
                map = this.sort4Json(conn);
            } else {
                return false;
            }
            Map<Integer, Integer> map2 = this.quChong(map);
            UpdateIpTask task = new UpdateIpTask(channelId, updateAll, map2);
            task.run();
            return true;
        }
        return false;
    }

    private Map<Integer, Integer> sort4Json(HttpURLConnection conn) throws IOException {
        String temp;
        StringBuffer sbf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        while ((temp = reader.readLine()) != null) {
            sbf.append(temp);
            sbf.append("\r\n");
        }
        reader.close();
        JSONObject res = JSONObject.parseObject((String)sbf.toString());
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        if (null != res) {
            JSONArray ipRange = res.getJSONArray("ip_range");
            List ips = ipRange.toJavaList(HeiNiuIp.class);
            ips.forEach(e -> {
                int startIp = IpUtils.getIntIp((String)e.getS());
                int endIp = IpUtils.getIntIp((String)e.getE());
                if (startIp != 0 && endIp != 0 && startIp < endIp) {
                    map.put(startIp, endIp);
                }
            });
        }
        return map;
    }

    private Map<Integer, Integer> sort4Txt(HttpURLConnection conn) throws IOException {
        String line;
        InputStream inputStream = conn.getInputStream();
        InputStreamReader inReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufReader = new BufferedReader(inReader);
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        while ((line = bufReader.readLine()) != null) {
            String[] split = line.split("-");
            if (split.length != 2) continue;
            int startIp = IpUtils.getIntIp((String)split[0]);
            int endIp = IpUtils.getIntIp((String)split[1]);
            if (startIp == 0 || endIp == 0 || startIp >= endIp) continue;
            map.put(startIp, endIp);
        }
        bufReader.close();
        inReader.close();
        return map;
    }

    private Map<Integer, Integer> quChong(Map<Integer, Integer> map) {
        Integer startIp = null;
        Integer endIp = null;
        int i = 1;
        TreeMap<Integer, Integer> map2 = new TreeMap<Integer, Integer>();
        Iterator<Map.Entry<Integer, Integer>> it = map.entrySet().iterator();
        Map.Entry<Integer, Integer> entry = null;
        while (it.hasNext()) {
            entry = it.next();
            Integer startIp2 = entry.getKey();
            Integer endIp2 = entry.getValue();
            if (i == 1) {
                map2.put(startIp2, endIp2);
                startIp = startIp2;
                endIp = endIp2;
            } else if (startIp2 <= endIp) {
                if (endIp2 >= endIp) {
                    map2.put(startIp, endIp2);
                    endIp = endIp2;
                }
            } else {
                map2.put(startIp2, endIp2);
                startIp = startIp2;
                endIp = endIp2;
            }
            i = 2;
        }
        return map2;
    }

    private void saveAndRefresh(int channelId, Map<Integer, Integer> map2, List<AdTicketIpDto> list) {
        AdTicketIpDO ap = new AdTicketIpDO();
        Date nowDate = new Date();
        ap.setIpLibrary(Integer.valueOf(channelId));
        ap.setCreateTime(nowDate);
        ap.setModifiedTime(nowDate);
        for (Map.Entry<Integer, Integer> entry : map2.entrySet()) {
            ap.setStartIp(entry.getKey());
            ap.setEndIp(entry.getValue());
            AdTicketIpDto adTicketIpDto = new AdTicketIpDto();
            BeanUtils.copyProperties((Object)ap, (Object)adTicketIpDto);
            this.adTicketIpMapper.save(ap);
            System.out.println(adTicketIpDto);
            list.add(adTicketIpDto);
            this.logger.info("start={}, end={}", (Object)IpUtils.getStringIp((int)entry.getKey()), (Object)IpUtils.getStringIp((int)entry.getValue()));
        }
        this.updater.hupdate(TicketKeyGenerator.Filter.getIpLibrary(), String.valueOf(channelId), list);
        this.logger.info("\u5e7f\u544a\u5b9a\u5411ip\u5e93\u5237\u65b0redis\u6210\u529f\uff0cchannel={},ipLibrary={}", (Object)channelId, (Object)JSONObject.toJSONString(list));
    }

    public boolean heiNiuResult(HeiNiuResult result, HttpServletRequest request) throws ThirdException {
        String order;
        this.checkToken(result.getToken());
        if ("1".equals(result.getIsSettle())) {
            this.click(result.getBxmId());
        }
        if (StringUtils.isBlank((String)(order = (String)this.jedisFetcherForOld.fetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"clickMsg", result.getBxmId()}), String.class, 11)))) {
            this.logger.error("\u9ed1\u725b\u843d\u5730\u9875bxmId\u9519\u8bef\uff1aresult={},orderId={}", (Object)result, (Object)result.getBxmId());
            throw new ThirdException(ErrorCode.E0000001.getCode(), "BXMID \u9519\u8bef");
        }
        String[] results = order.split(":");
        if (results.length < 6) {
            this.logger.error("\u9ed1\u725b\u843d\u5730\u9875bxmId\u9519\u8bef\uff1aresult={},orderId={}", (Object)results, (Object)result.getBxmId());
            throw new ThirdException(ErrorCode.E0000001.getCode(), "BXMID \u9519\u8bef");
        }
        LandInterfaceDO landInterfaceDO = new LandInterfaceDO();
        landInterfaceDO.setAskDirection(Integer.valueOf(2));
        landInterfaceDO.setChannel(LandChannel.HEINIU.getChannel());
        landInterfaceDO.setOrderId(result.getBxmId());
        landInterfaceDO.setUid(results[5]);
        landInterfaceDO.setUrl(request.getRequestURI());
        landInterfaceDO.setRequest(JSONObject.toJSONString((Object)result));
        this.landInterfaceMapper.save(landInterfaceDO);
        return true;
    }

    private void click(String orderId) {
        String url = this.clickDomain + "/shop/countInfo?bxm_id=" + orderId + "&status=1&modeltype=7";
        try {
            Jsoup.connect((String)url).data(new String[0]).ignoreContentType(true).method(Connection.Method.GET).execute();
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55\u9ed1\u725b\u843d\u5730\u9875\u6709\u6548\u70b9\u51fb\u5931\u8d25,url={}, cause={}", (Object)url, (Object)e);
        }
    }

    private void checkToken(String token) throws ThirdException {
        if (!StringUtils.equals((String)token, (String)"6d32aa19-749c-11e8-8e99-dca90487e6d2")) {
            throw new ThirdException(ErrorCode.E0100006);
        }
    }

    private class UpdateIpTask
    implements Runnable {
        private int channelId;
        private int updateAll;
        private Map<Integer, Integer> map;

        public UpdateIpTask(int channelId, int updateAll, Map<Integer, Integer> map) {
            this.channelId = channelId;
            this.updateAll = updateAll;
            this.map = map;
        }

        @Override
        public void run() {
            List list = Lists.newArrayList();
            if (UpdateType.INCREMENTAL.getValue().equals(this.updateAll)) {
                list = ThirdService.this.fetcher.hfetchList(TicketKeyGenerator.Filter.getIpLibrary(), String.valueOf(this.channelId), AdTicketIpDto.class);
            } else if (UpdateType.FULL.getValue().equals(this.updateAll)) {
                ThirdService.this.adTicketIpMapper.deleteByChannelId(this.channelId);
            }
            ThirdService.this.saveAndRefresh(this.channelId, this.map, list);
        }
    }
}

