/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.service.landpage.impl;

import com.bxm.adsprod.third.model.landpage.Auth;
import com.bxm.adsprod.third.service.landpage.AuthService;
import com.bxm.warcar.integration.pair.MutablePair;
import com.bxm.warcar.integration.pair.Value;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    private final MutablePair pair;

    public AuthServiceImpl(MutablePair pair) {
        this.pair = pair;
    }

    @Override
    public void saveOrUpdate(Auth auth) {
        Preconditions.checkNotNull((Object)auth);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)auth.getToken()));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(auth.getPageids()));
        String key = this.getKey(auth.getToken());
        this.pair.set(key, JsonHelper.convert((Object)auth));
    }

    @Override
    public boolean hasPermission(String token, String pageId) {
        String key = this.getKey(token);
        Value value = this.pair.get(key);
        Auth auth = (Auth)value.toObject(Auth.class);
        if (null == auth) {
            return false;
        }
        Set<String> pageids = auth.getPageids();
        return CollectionUtils.isNotEmpty(pageids) && pageids.contains(pageId);
    }

    private String getKey(String token) {
        return "adsprod-landpage:auth:" + token;
    }
}

