#!/bin/bash

if [ ! -f ~/run/adsprod-third.pid ]; then
  echo "Server [adsprod-third] doest not started!"
  exit
fi

pid=`cat ~/run/adsprod-third.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adsprod-third.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adsprod-third] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adsprod-third] cannot stop, Please check pid file 'adsprod-third.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adsprod-third] has been stoped!"
fi

rm -f ~/run/adsprod-third.pid