package com.bxm.adsprod.timer.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.activity.ActivityService;
import com.bxm.adsprod.facade.activity.WeightEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.bxm.adsprod.dal.activity.ActivityMapper;
import com.bxm.adsprod.facade.activity.ActivityKeyGenerator;
import com.bxm.adsprod.model.dto.ActivityDataDto;
import com.bxm.adsprod.model.dto.ActivityPositionRelationDto;
import com.bxm.adsprod.model.dto.ActivityPositonWeightDto;
import com.bxm.adsprod.timer.Job;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**  
* @Title: ActivityDataPullJob 
* @Description:  活动权重计算
* @author xavier  
* @date 2018年5月9日  
*/  
@Component
public class ActivityDataPullJob implements Job{
	
	private static final Logger LOGGER = LoggerFactory.getLogger(PositionDataPullJob.class);
	/** The default weight value */  
	private static final int DEFAULT_WEIGHT = 200;
	private static final String SPLIT_CHAR = ",";
	@Value("${activity.db}")
	private int activityDb;
	
	@Autowired
    private JedisPool jedisPool;

	@Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
	
	@Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
	
	@Autowired
	private ActivityMapper activityMapper;

	@Reference(version = "1.0.0")
	private ActivityService activityService;

    @Override
//    @Scheduled(cron="0 0/5 * * * ?")
// 该定时任务迁移到活动activities-timer
    public void execute() {
    	Long start = System.currentTimeMillis();
    	try {
    		KeyGenerator tmpPostion6H = ActivityKeyGenerator.Filter.getTmpPostion6H();
        	String positionStr = fetcher.fetchWithSelector(tmpPostion6H, String.class, activityDb);
        	//查询备用的活动
        	positionStr += SPLIT_CHAR + "DEFAULT";
        	//查询广告位活动配置信息
        	String[] positionIds = StringUtils.split(positionStr, SPLIT_CHAR);
        	//查询现有的广告位活动配置信息
        	Map<String, List<ActivityPositonWeightDto>> positionAct = getPositonActMap();
        	List<ActivityPositonWeightDto> defaultAct = activityMapper.selectDefaultAct(new Date());
        	//查询活动阈值数据
        	KeyGenerator defaultNumKey = ActivityKeyGenerator.Filter.getActDefaultNum();
    		String dafaultView = fetcher.fetchWithSelector(defaultNumKey, String.class, activityDb);
    		dafaultView = StringUtils.isNotBlank(dafaultView) ? dafaultView : "100";
    		//查询默认的人均点击值
    		KeyGenerator defaultRepeatKey = ActivityKeyGenerator.Filter.getActDefaultRepeat();
    		String defaultRepeatClicks = fetcher.fetchWithSelector(defaultRepeatKey, String.class, activityDb);
    		defaultRepeatClicks = StringUtils.isNotBlank(defaultRepeatClicks) ? defaultRepeatClicks : "200";
        	//循环广告位配置信息
        	for (String positionId : positionIds) {
        		//广告位所有的活动ID
    			List<ActivityPositonWeightDto> actWeightList = positionAct.get(positionId);
				actWeightList = CollectionUtils.isEmpty(actWeightList) ? defaultAct : actWeightList;
				//活动ID与人工系数组成的Map
				Map<Integer,Integer>  activityIdFactor = extractActivityAndFactorInfo(actWeightList);

				List<WeightEntry> entries = activityService.getPerClick(positionId, dafaultView,defaultRepeatClicks,activityIdFactor);
    			
    			Map<Integer, Integer> weights = Maps.newHashMap();
    			//计算每个活动的权重值 
    			int totalSize = 1;
    			for (WeightEntry weightEntry : entries) {
					weights.put(weightEntry.getActivityId(), 
							weightEntry.getWeight() * totalSize * weightEntry.getInterventionFactor());
					totalSize ++;
				}
    			
    			//保存到redis
    			KeyGenerator actRandomKey = ActivityKeyGenerator.Filter.getActRandomMsg(positionId);
    			updater.updateWithSelector(actRandomKey, weights, activityDb);
    		}
        	Long end = System.currentTimeMillis();
        	LOGGER.info("Pull activity finished in" + (start - end));
		} catch (Exception e) {
			LOGGER.error("EXCUTE BIZACTWEIGHT ERROR", e);
		}
    }

	private Map<Integer,Integer> extractActivityAndFactorInfo(List<ActivityPositonWeightDto> actWeightList) {
    	Map<Integer,Integer> map = new HashMap<>();
    	if(CollectionUtils.isNotEmpty(actWeightList)){
			for (ActivityPositonWeightDto weight:actWeightList) {
    			map.put(weight.getActivityId(),weight.getInterventionFactor());

			}
		}
		return map;
	}

	/**
     * @Title: getPositonActMap  
     * @Description:  拼装广告位活动配置信息
     * @author xavier  
     * @date 2018年5月13日
     */  
    public Map<String, List<ActivityPositonWeightDto>> getPositonActMap(){
    	List<ActivityPositionRelationDto> actRelations = activityMapper.selectPostionAct(new Date());
    	Map<String, List<ActivityPositonWeightDto>> result = new HashMap<>();
    	for (ActivityPositionRelationDto relation : actRelations) {
    		String positionId = relation.getPositionId();
    		//初始化广告位权重信息
    		ActivityPositonWeightDto value = new ActivityPositonWeightDto();
    		value.setActivityId(relation.getActivityId());
    		value.setInterventionFactor(relation.getInterventionFactor());
    		
    		List<ActivityPositonWeightDto> record = result.get(positionId);
    		//若MAP已经存在则更新，否则新增
    		record = record == null ? new ArrayList<>() : record;
    		record.add(value);
    		result.put(positionId, record);
		}
    	return result;
    }
    


}
