/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.mongo.config;

import com.bxm.adsprod.weight.mongo.config.AbstractMongoConfig;
import com.mongodb.MongoClientOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@ConfigurationProperties(prefix="spring.data.mongodb.primary")
public class PrimaryMongoConfig
extends AbstractMongoConfig {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    @Primary
    @Bean
    public MongoTemplate getMongoTemplate() throws Exception {
        MongoMappingContext mongoMappingContext = new MongoMappingContext();
        mongoMappingContext.setApplicationContext(this.applicationContext);
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(this.mongoDbFactory()), (MappingContext)mongoMappingContext);
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return new MongoTemplate(this.mongoDbFactory(), (MongoConverter)converter);
    }

    @Bean
    public MongoClientOptions mongoOptions() {
        return MongoClientOptions.builder().maxConnectionIdleTime(6000).build();
    }
}

