/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.mongo.service.base;

import com.bxm.adsprod.weight.mongo.service.util.Page;
import com.bxm.adsprod.weight.mongo.service.util.ReflectionUtils;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class MongoCommonDao<T> {
    private static final int DEFAULT_SKIP = 0;
    private static final int DEFAULT_LIMIT = 100;
    protected MongoTemplate mongoTemplate;

    public List<T> find(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    public List<T> find(Query query, String collectionName) {
        return this.mongoTemplate.find(query, this.getEntityClass(), collectionName);
    }

    public List<T> find(Query query, Class<T> clazz, String collectionName) {
        return this.mongoTemplate.find(query, clazz, collectionName);
    }

    public T findOne(Query query) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    public T findOne(Query query, String collectionName) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass(), collectionName);
    }

    public Object findOne(Query query, Class<?> clazz, String collectionName) {
        return this.mongoTemplate.findOne(query, clazz, collectionName);
    }

    public void update(Query query, Update update) {
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass());
    }

    public void update(Query query, Update update, String collectionName) {
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass(), collectionName);
    }

    public void update(Query query, Update update, Class<?> clazz, String collectionName) {
        this.mongoTemplate.findAndModify(query, update, clazz, collectionName);
    }

    public T save(T entity) {
        this.mongoTemplate.insert(entity);
        return entity;
    }

    public T save(T entity, String collectionName) {
        this.mongoTemplate.insert(entity, collectionName);
        return entity;
    }

    public void saveBatch(List<T> t, String collectionName) {
        this.mongoTemplate.insert(t, collectionName);
    }

    public void remove(Query query, String collectionName) {
        if (this.mongoTemplate.exists(query, collectionName)) {
            this.mongoTemplate.remove(query, collectionName);
        }
    }

    public void drop(String collectionName) {
        this.mongoTemplate.dropCollection(collectionName);
    }

    public T findById(String id) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass());
    }

    public T findById(String id, String collectionName) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass(), collectionName);
    }

    public Page<T> findPage(Integer pageNum, Integer pageSize, Query query) {
        Long total = this.count(query);
        if (pageNum == null || pageSize == null) {
            query.skip(0);
        } else {
            query.skip((pageNum - 1) * pageSize);
        }
        if (pageSize == null) {
            query.limit(100);
        } else {
            query.limit(pageSize.intValue());
        }
        return new Page<T>(this.find(query), pageNum, pageSize, total);
    }

    public Page<T> findPage(Integer pageNum, Integer pageSize, Query query, String collectionName) {
        Long total = this.count(query, collectionName);
        if (pageNum == null || pageSize == null) {
            query.skip(0);
        } else {
            query.skip((pageNum - 1) * pageSize);
        }
        if (pageSize == null) {
            query.limit(100);
        } else {
            query.limit(pageSize.intValue());
        }
        return new Page<T>(this.find(query, collectionName), pageNum, pageSize, total);
    }

    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    public long count(Query query, String collectionName) {
        return this.mongoTemplate.count(query, this.getEntityClass(), collectionName);
    }

    public List<T> sum(String collectionName, MatchOperation match, GroupOperation group) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group});
        AggregationResults aggRes = this.mongoTemplate.aggregate(aggregation, collectionName, this.getEntityClass());
        return aggRes.getMappedResults();
    }

    private Class<T> getEntityClass() {
        return ReflectionUtils.getSuperClassGenricType(this.getClass());
    }

    protected abstract void setMongoTemplate(MongoTemplate var1);

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }
}

