/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.scheduler;

import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.weight.Scheduler;
import com.bxm.adsprod.weight.commons.WeightConfiguration;
import com.bxm.adsprod.weight.model.TicketGlobalArpu;
import com.bxm.adsprod.weight.model.TicketHourWeight;
import com.bxm.adsprod.weight.model.TicketNarpu;
import com.bxm.adsprod.weight.model.TicketWeightResult;
import com.bxm.adsprod.weight.mongo.service.TicketGlobalArpuService;
import com.bxm.adsprod.weight.mongo.service.TicketHourWeightService;
import com.bxm.adsprod.weight.mongo.service.TicketNarpuService;
import com.bxm.adsprod.weight.scheduler.service.MifCalculator;
import com.bxm.adsprod.weight.scheduler.service.PriceFloatCalculator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableConfigurationProperties(value={WeightConfiguration.class})
public class WeightCalculateScheduler
implements Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(WeightCalculateScheduler.class);
    private final ExecutorService primaryPool;
    private final ExecutorService primaryHourPool;
    @Autowired
    TicketNarpuService ticketNarpuService;
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;
    @Reference(version="1.0.0")
    private TicketService ticketService;
    @Autowired
    private PriceFloatCalculator priceFloatCalculator;
    @Autowired
    private MifCalculator mifCalculator;
    @Autowired
    @Qualifier(value="jedisUpdaterForOld")
    private JedisUpdater jedisUpdaterOld;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private JedisUpdater jedisUpdater;
    @Autowired
    private TicketGlobalArpuService ticketGlobalArpuService;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private TicketHourWeightService ticketHourWeightService;
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public WeightCalculateScheduler(WeightConfiguration configuration) {
        this.primaryPool = new ThreadPoolExecutor(configuration.getPrimaryPoolSize(), configuration.getPrimaryPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("PrimaryPoolWeightCalculator"));
        this.primaryHourPool = new ThreadPoolExecutor(configuration.getPrimaryPoolSize(), configuration.getPrimaryPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("PrimaryPoolWeightHourCalculator"));
    }

    @Override
    @Scheduled(cron="0 0/5 * * * ?")
    public void schedule() {
        List tickets;
        long start = System.currentTimeMillis();
        final LocalDateTime localDateTime = LocalDateTime.now();
        final LocalDateTime localDateTimeplus5m = localDateTime.plusMinutes(5L);
        if (logger.isInfoEnabled()) {
            logger.info("Starting calculation weight ...");
        }
        if (CollectionUtils.isEmpty((Collection)(tickets = this.ticketService.getAllTickets()))) {
            if (logger.isWarnEnabled()) {
                logger.warn("No any ticket!");
            }
            return;
        }
        final HashSet<BigInteger> cpcSet = new HashSet<BigInteger>();
        for (Ticket ticket : tickets) {
            BigInteger ticketId = ticket.getId();
            if (ticket.getSettleType() != 1 || ticket.isOcpc()) continue;
            cpcSet.add(ticketId);
        }
        final ConcurrentMap ticketArpuCache = Maps.newConcurrentMap();
        final Map<BigInteger, Ticket> ticketCache = this.ticketList2Map(tickets);
        List<TicketGlobalArpu> ticketGlobalArpuList = this.ticketGlobalArpuService.find(new Query(), "ad_certificate_arpu_two_days_stat");
        final Map<BigInteger, BigDecimal> ticketGlobalArpuMap = this.ticketGlobalArpuList2ticketGlobalArpuMap(ticketGlobalArpuList, ticketCache);
        this.pushGlobalArpuMap2Redis(ticketGlobalArpuMap);
        List<TicketNarpu> ticketNarpuList = this.getTicketNarpuList();
        final TicketWeightResult ticketWeightResult = new TicketWeightResult();
        ArrayList ticketFutures = Lists.newArrayList();
        final ArrayList ticketHourFutures = Lists.newArrayList();
        final AtomicInteger count = new AtomicInteger(0);
        final ConcurrentMap mifCache = Maps.newConcurrentMap();
        final ConcurrentMap mifMediaCache = Maps.newConcurrentMap();
        final ConcurrentMap pfCache = Maps.newConcurrentMap();
        for (final TicketNarpu ticketNarpu : ticketNarpuList) {
            Future<TicketWeightResult> ticketFuture = this.primaryPool.submit(new Callable<TicketWeightResult>(){

                @Override
                public TicketWeightResult call() throws Exception {
                    return this.calculator();
                }

                private TicketWeightResult calculator() {
                    int plus5mHour;
                    BigDecimal intervene;
                    BigDecimal arpu = this.dealTicketNarpu(ticketNarpu, ticketGlobalArpuMap);
                    String positionId = ticketNarpu.getPositionId();
                    BigInteger ticketId = ticketNarpu.getCertificateId();
                    BigDecimal priceFloat = PriceFloatCalculator.DEFAULT;
                    if (cpcSet.contains(ticketId)) {
                        if (pfCache.containsKey(ticketId)) {
                            priceFloat = (BigDecimal)pfCache.get(ticketId);
                        } else {
                            priceFloat = WeightCalculateScheduler.this.priceFloatCalculator.getPf(ticketId);
                            if (priceFloat == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("redis not contains key AD:WEIGHT:TICKET_PRICE_FP:{}", (Object)ticketId);
                                }
                                priceFloat = PriceFloatCalculator.DEFAULT;
                            }
                            pfCache.put(ticketId, priceFloat);
                        }
                    }
                    if (null == (intervene = (BigDecimal)mifCache.get(ticketId))) {
                        intervene = WeightCalculateScheduler.this.mifCalculator.getMif(ticketId);
                        if (intervene == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("redis not contains key AD:WEIGHT:TICKET_MIF:{}", (Object)ticketId);
                            }
                            intervene = MifCalculator.DEFAULT;
                        }
                        mifCache.put(ticketId, intervene);
                    }
                    if (mifMediaCache.get(ticketNarpu.getPositionId()) == null) {
                        Map positionMedia = WeightCalculateScheduler.this.fetcher.hfetchall(() -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "POSITION_MIF", ticketNarpu.getPositionId()}), BigDecimal.class);
                        if (positionMedia == null) {
                            positionMedia = Maps.newHashMap();
                        }
                        mifMediaCache.put(ticketNarpu.getPositionId(), positionMedia);
                    }
                    BigDecimal media = new BigDecimal(1);
                    Map mediaMap = (Map)mifMediaCache.get(positionId);
                    if (mediaMap == null) {
                        Map positionMedia = WeightCalculateScheduler.this.fetcher.hfetchall(() -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "POSITION_MIF", ticketNarpu.getPositionId()}), BigDecimal.class);
                        if (positionMedia == null) {
                            positionMedia = Maps.newHashMap();
                        }
                        mifMediaCache.put(ticketNarpu.getPositionId(), positionMedia);
                        mediaMap = positionMedia;
                    }
                    if (mediaMap.get(ticketId.toString()) != null) {
                        media = (BigDecimal)mediaMap.get(ticketId.toString());
                    }
                    BigDecimal weight = arpu.multiply(priceFloat).multiply(intervene).multiply(media).setScale(7, RoundingMode.HALF_UP);
                    int localHour = localDateTime.getHour();
                    if (localHour != (plus5mHour = localDateTimeplus5m.getHour())) {
                        Future hourFuture = WeightCalculateScheduler.this.sendTicketPositionHourWeight2Mongo(ticketId, positionId, weight, weight + " = " + arpu + " * " + priceFloat + " * " + intervene + " * " + media, count, localDateTime, localDateTimeplus5m);
                        ticketHourFutures.add(hourFuture);
                    }
                    ticketWeightResult.getIndex().getAndIncrement();
                    ConcurrentHashMap<String, Map<BigInteger, BigDecimal>> ticketWeightKey = ticketWeightResult.getTicketWeightKey();
                    Map<BigInteger, BigDecimal> ticketArpuMap = ticketWeightKey.get(positionId);
                    if (ticketArpuMap == null) {
                        ticketArpuMap = new ConcurrentHashMap<BigInteger, BigDecimal>(3000);
                        ticketWeightKey.put(positionId, ticketArpuMap);
                    }
                    ticketArpuMap.put(ticketId, weight);
                    return ticketWeightResult;
                }

                private BigDecimal dealTicketNarpu(TicketNarpu ticketNarpu2, Map<BigInteger, BigDecimal> ticketGlobalArpuMap2) {
                    Integer option = ticketNarpu2.getType();
                    if (0 == option) {
                        return new BigDecimal(ticketNarpu2.getNarpu());
                    }
                    if (1 == option) {
                        return this.getDefaultArpu(ticketNarpu2.getCertificateId());
                    }
                    if (2 == option) {
                        BigInteger certificateId = ticketNarpu2.getCertificateId();
                        BigDecimal globalArpu = ticketGlobalArpuMap2.get(certificateId);
                        if (globalArpu == null) {
                            return this.getDefaultArpu(certificateId);
                        }
                        return globalArpu;
                    }
                    return null;
                }

                private BigDecimal getDefaultArpu(BigInteger ticketId) {
                    Ticket ticket = (Ticket)ticketCache.get(ticketId);
                    if (ticket != null) {
                        String arpuKey = ticket.getDomainCode() + "-" + ticket.getSettleType();
                        if (ticketArpuCache.containsKey(arpuKey)) {
                            return (BigDecimal)ticketArpuCache.get(arpuKey);
                        }
                        BigDecimal arpu = WeightCalculateScheduler.this.getDomainArpu(ticket);
                        ticketArpuCache.put(arpuKey, arpu);
                        return arpu;
                    }
                    return WeightCalculateScheduler.this.getDomainArpu(null);
                }
            });
            ticketFutures.add(ticketFuture);
        }
        int size = ticketNarpuList.size();
        for (Future future : ticketFutures) {
            try {
                boolean isLast;
                TicketWeightResult result = (TicketWeightResult)future.get();
                Integer index = result.getIndex().get();
                boolean isPrint = index % 100 == 0;
                boolean bl = isLast = index == size;
                if (!isPrint || !logger.isInfoEnabled() || isLast) continue;
                logger.info("weight Processing {}/{}", (Object)index, (Object)size);
            }
            catch (InterruptedException | ExecutionException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("get: ", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("All ticket calculate weight has been finished in {} ms, start push redis...", (Object)(System.currentTimeMillis() - start));
        }
        this.batchPushRedis(ticketWeightResult);
        if (logger.isInfoEnabled()) {
            logger.info("All ticket weight has been finished in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        for (Future future : ticketHourFutures) {
            try {
                boolean isLast;
                if (future == null) continue;
                Integer index = (Integer)future.get();
                boolean isPrint = index % 100 == 0;
                boolean bl = isLast = index == size;
                if (!isPrint || !logger.isInfoEnabled() || isLast) continue;
                logger.info("weight hour value push to mongo Processing {}/{}", (Object)index, (Object)size);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("get: ", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("All weight hour value push to mongo has been finished in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        tickets.clear();
        cpcSet.clear();
        ticketCache.clear();
        ticketGlobalArpuList.clear();
        ticketGlobalArpuMap.clear();
        ticketNarpuList.clear();
        ticketFutures.clear();
        ticketArpuCache.clear();
        mifCache.clear();
        mifMediaCache.clear();
        pfCache.clear();
        ticketWeightResult.clear();
    }

    private Future<Integer> sendTicketPositionHourWeight2Mongo(final BigInteger ticketId, final String positionId, final BigDecimal weight, final String calculate, final AtomicInteger count, final LocalDateTime localDateTime, final LocalDateTime localDateTimeplus5m) {
        Future<Integer> future = this.primaryHourPool.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int plus5mHour;
                int localHour = localDateTime.getHour();
                if (localHour != (plus5mHour = localDateTimeplus5m.getHour())) {
                    long start = System.currentTimeMillis();
                    String appkey = "mistake_appkey";
                    String business = "mistake_biz";
                    if (positionId.contains("-")) {
                        if (positionId.split("-").length == 2) {
                            appkey = positionId.split("-")[0];
                            business = "ad-" + positionId.split("-")[1];
                        } else {
                            appkey = positionId.split("-")[0];
                        }
                    } else {
                        appkey = positionId;
                    }
                    Criteria criteria = Criteria.where((String)"certificate_id").is((Object)ticketId.intValue());
                    if (appkey != null) {
                        criteria.and("appkey").is((Object)appkey);
                    } else {
                        criteria.and("appkey").is(null);
                    }
                    if (business != null) {
                        criteria.and("business").is((Object)business);
                    } else {
                        criteria.and("business").is(null);
                    }
                    if (plus5mHour == 0) {
                        String oldDate = dateTimeFormatter.format(localDateTimeplus5m.minusDays(1L));
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)criteria);
                        long count2 = WeightCalculateScheduler.this.ticketHourWeightService.count(query, "ad_certificate_weight_d_stat_" + oldDate);
                        TicketHourWeight ticketHourWeight = new TicketHourWeight();
                        if (count2 > 0L) {
                            Update update = new Update();
                            update.set("weight_24", (Object)weight.doubleValue());
                            update.set("weight_24_calculate", (Object)calculate);
                            WeightCalculateScheduler.this.ticketHourWeightService.update(query, update, "ad_certificate_weight_d_stat_" + oldDate);
                        } else {
                            ticketHourWeight.setAppkey(appkey);
                            ticketHourWeight.setBusiness(business);
                            ticketHourWeight.setCertificateId(ticketId.intValue());
                            ticketHourWeight.setWeight24(weight.doubleValue());
                            ticketHourWeight.setWeight24Calculate(calculate);
                            WeightCalculateScheduler.this.ticketHourWeightService.save(ticketHourWeight, "ad_certificate_weight_d_stat_" + oldDate);
                            WeightCalculateScheduler.this.createMongoIndex(oldDate);
                        }
                        String date = dateTimeFormatter.format(localDateTimeplus5m);
                        ticketHourWeight = new TicketHourWeight();
                        ticketHourWeight.setAppkey(appkey);
                        ticketHourWeight.setBusiness(business);
                        ticketHourWeight.setCertificateId(ticketId.intValue());
                        ticketHourWeight.setWeight0(weight.doubleValue());
                        ticketHourWeight.setWeight0Calculate(calculate);
                        WeightCalculateScheduler.this.ticketHourWeightService.save(ticketHourWeight, "ad_certificate_weight_d_stat_" + date);
                        WeightCalculateScheduler.this.createMongoIndex(date);
                    } else {
                        String date = dateTimeFormatter.format(localDateTime);
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)criteria);
                        long count3 = WeightCalculateScheduler.this.ticketHourWeightService.count(query, "ad_certificate_weight_d_stat_" + date);
                        if (count3 > 0L) {
                            Update update = new Update();
                            update.set("weight_" + plus5mHour, (Object)weight.doubleValue());
                            update.set("weight_" + plus5mHour + "_calculate", (Object)calculate);
                            WeightCalculateScheduler.this.ticketHourWeightService.update(query, update, "ad_certificate_weight_d_stat_" + date);
                        } else {
                            TicketHourWeight ticketHourWeight = new TicketHourWeight();
                            ticketHourWeight.setBusiness(business);
                            ticketHourWeight.setAppkey(appkey);
                            ticketHourWeight.setCertificateId(ticketId.intValue());
                            WeightCalculateScheduler.this.setWeightCalculateValue(ticketHourWeight, plus5mHour, weight, calculate);
                            WeightCalculateScheduler.this.ticketHourWeightService.save(ticketHourWeight, "ad_certificate_weight_d_stat_" + date);
                            WeightCalculateScheduler.this.createMongoIndex(date);
                        }
                    }
                    long end = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug("sendTicketPositionHourWeight2Mongo execute {} ms", (Object)(end - start));
                    }
                }
                return count.getAndIncrement();
            }
        });
        return future;
    }

    private void createMongoIndex(String date) {
        DBCollection collection = this.ticketHourWeightService.getMongoTemplate().getCollection("ad_certificate_weight_d_stat_" + date);
        BasicDBObject basicDBObjectTwo = new BasicDBObject();
        basicDBObjectTwo.put((Object)"certificate_id", (Object)1);
        basicDBObjectTwo.put((Object)"appkey", (Object)1);
        collection.createIndex((DBObject)basicDBObjectTwo);
        BasicDBObject basicDBObjectThree = new BasicDBObject();
        basicDBObjectThree.put((Object)"certificate_id", (Object)1);
        basicDBObjectThree.put((Object)"appkey", (Object)1);
        basicDBObjectThree.put((Object)"business", (Object)1);
        collection.createIndex((DBObject)basicDBObjectThree);
    }

    public void setWeightCalculateValue(TicketHourWeight ticketHourWeight, int hour, BigDecimal weight, String calculate) {
        try {
            Method weightMethod = ticketHourWeight.getClass().getMethod("setWeight" + hour, Double.class);
            Method calculateMethod = ticketHourWeight.getClass().getMethod("setWeight" + hour + "Calculate", String.class);
            weightMethod.invoke((Object)ticketHourWeight, weight.doubleValue());
            calculateMethod.invoke((Object)ticketHourWeight, calculate);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private List<TicketNarpu> getTicketNarpuList() {
        List ticketNarpuList = this.ticketNarpuService.find(new Query(), "ad_certificate_cpc_narpu_hour_stat");
        HashMap<String, TicketNarpu> ticketNarpuMap = new HashMap<String, TicketNarpu>(ticketNarpuList.size());
        for (TicketNarpu ticketNarpu : ticketNarpuList) {
            ticketNarpuMap.put(ticketNarpu.getPositionIdAndcertificateId(), ticketNarpu);
        }
        List<TicketNarpu> allTicketAndPositionList = this.getAllTicketAndPositionList();
        HashMap<String, TicketNarpu> allTicketAndPositionMap = new HashMap<String, TicketNarpu>(allTicketAndPositionList.size());
        for (TicketNarpu ticketNarpu : allTicketAndPositionList) {
            allTicketAndPositionMap.put(ticketNarpu.getPositionIdAndcertificateId(), ticketNarpu);
        }
        Set entries = ticketNarpuMap.entrySet();
        for (Map.Entry entry : entries) {
            allTicketAndPositionMap.put((String)entry.getKey(), (TicketNarpu)entry.getValue());
        }
        return new ArrayList<TicketNarpu>(allTicketAndPositionMap.values());
    }

    private List<TicketNarpu> getAllTicketAndPositionList() {
        List<TicketCache> ticketCache = this.getAvailableTickets();
        if (CollectionUtils.isEmpty(ticketCache)) {
            ticketCache = new ArrayList<TicketCache>();
        }
        List ticketIdList = ticketCache.stream().map(TicketCache::getId).map(BigInteger::toString).collect(Collectors.toList());
        String positions = (String)this.fetcher.fetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TEMP", "POSITIONS", "6H"}), String.class, 3);
        if (StringUtils.isEmpty((String)positions)) {
            positions = "";
        }
        List<String> positionList = Arrays.asList(positions.split(","));
        ArrayList<TicketNarpu> ticketNarpuList = new ArrayList<TicketNarpu>(ticketIdList.size() * positionList.size());
        for (String ticketId : ticketIdList) {
            for (String positionId : positionList) {
                if (StringUtils.isBlank((String)positionId)) continue;
                TicketNarpu ticketNarpu = new TicketNarpu();
                ticketNarpu.setCertificateId(TypeHelper.castToBigInteger((Object)ticketId));
                ticketNarpu.setPositionId(positionId);
                ticketNarpu.setType(2);
                ticketNarpuList.add(ticketNarpu);
            }
        }
        return ticketNarpuList;
    }

    private List<TicketCache> getAvailableTickets() {
        Map hfetchall = this.fetcher.hfetchall(TicketKeyGenerator.getAvailableTickets(), null, TicketCache.class);
        if (MapUtils.isEmpty((Map)hfetchall)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(hfetchall.values());
    }

    public BigDecimal getTicketArpu(BigInteger ticketId, String positionId) {
        if (ticketId == null || positionId == null) {
            return this.getDomainArpu(null);
        }
        BigDecimal arpu = null;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"positionid").is((Object)positionId)).addCriteria((CriteriaDefinition)Criteria.where((String)"certificate_id").is((Object)ticketId));
        TicketNarpu ticketNarpu = (TicketNarpu)this.ticketNarpuService.findOne(query, "ad_certificate_cpc_narpu_hour_stat");
        if (ticketNarpu != null) {
            int type = ticketNarpu.getType();
            if (2 == type) {
                arpu = (BigDecimal)this.jedisFetcherForOld.fetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "TICKET", ticketId}), BigDecimal.class);
                if (arpu == null) {
                    arpu = this.getDefaultArpu(ticketId);
                }
            } else if (1 == type) {
                arpu = this.getDefaultArpu(ticketId);
            } else if (0 == type) {
                arpu = new BigDecimal(ticketNarpu.getNarpu());
            }
        } else {
            arpu = this.getDefaultArpu(ticketId);
        }
        return arpu;
    }

    private BigDecimal getDefaultArpu(BigInteger ticketId) {
        Ticket ticket = this.ticketService.get(ticketId);
        BigDecimal arpu = this.getDomainArpu(ticket);
        return arpu;
    }

    private void batchPushRedis(TicketWeightResult ticketWeightResult) {
        long start = System.currentTimeMillis();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        ArrayList futures = new ArrayList();
        ConcurrentHashMap<String, Map<BigInteger, BigDecimal>> ticketWeightKey = ticketWeightResult.getTicketWeightKey();
        ticketWeightKey.forEach((positionId, ticketArpuMap) -> {
            Future<Integer> future = this.primaryPool.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    Map<String, String> map = this.ticketArpuMap2StringMap(ticketArpuMap);
                    WeightCalculateScheduler.this.jedisUpdater.hmupdate(() -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", positionId}), map);
                    return atomicInteger.getAndIncrement();
                }

                private Map<String, String> ticketArpuMap2StringMap(Map<BigInteger, BigDecimal> ticketArpuMap2) {
                    HashMap<String, String> result = new HashMap<String, String>(ticketArpuMap2.size());
                    ticketArpuMap2.forEach((ticketId, arpu) -> result.put(ticketId.toString(), arpu.toString()));
                    return result;
                }
            });
            futures.add(future);
        });
        int size = ticketWeightKey.size();
        for (Future future : futures) {
            try {
                Integer index = (Integer)future.get();
                boolean isPrint = index % 100 == 0 || index == size;
                if (!isPrint || !logger.isInfoEnabled()) continue;
                logger.info("push redis Processing {}/{}", (Object)index, (Object)size);
            }
            catch (InterruptedException | ExecutionException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("get: ", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("All ticket weight push redis has been finished in {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private Map<BigInteger, Ticket> ticketList2Map(List<Ticket> tickets) {
        ConcurrentMap ticketMap = Maps.newConcurrentMap();
        tickets.forEach(ticket -> ticketMap.put(ticket.getId(), ticket));
        return ticketMap;
    }

    private Map<BigInteger, BigDecimal> ticketGlobalArpuList2ticketGlobalArpuMap(List<TicketGlobalArpu> ticketGlobalArpuList, Map<BigInteger, Ticket> ticketCache) {
        ConcurrentMap result = Maps.newConcurrentMap();
        ticketGlobalArpuList.forEach(ticketGlobalArpu -> {
            BigDecimal arpu = ticketGlobalArpu.getArpu();
            if (arpu == null) {
                arpu = this.getDomainArpu((Ticket)ticketCache.get(ticketGlobalArpu.getCertificateId()));
                if (logger.isDebugEnabled()) {
                    logger.debug("mongo \u96c6\u5408 {} \u4e2d\u672a\u53d6\u5230 ticketId: {} \u7684\u5927\u76d8arpu\u503c\uff0c\u53d6\u9ed8\u8ba4arpu\u503c{} \uff01", new Object[]{"ad_certificate_arpu_two_days_stat", ticketGlobalArpu.getCertificateId(), arpu});
                }
            }
            result.put(ticketGlobalArpu.getCertificateId(), arpu);
        });
        return result;
    }

    private void pushGlobalArpuMap2Redis(Map<BigInteger, BigDecimal> ticketGlobalArpuMap) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a8\u9001\u5927\u76d8arpu\u503c\u5230redis,size:{}", (Object)ticketGlobalArpuMap.size());
        }
        ticketGlobalArpuMap.forEach((ticket, arpu) -> this.jedisUpdaterOld.update(() -> KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "TICKET", ticket}), arpu));
    }

    private BigDecimal getDomainArpu(Ticket ticket) {
        Byte settleType;
        BigDecimal resultArpu = null;
        if (ticket == null) {
            return new BigDecimal(0.02).setScale(7, RoundingMode.HALF_UP);
        }
        String domainCode = ticket.getDomainCode();
        BigDecimal globalArpu = (BigDecimal)this.jedisFetcherForOld.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "ARPU", "DOMAIN", domainCode}), (settleType = ticket.getSettleType()) != null ? settleType.toString() : String.valueOf(2), BigDecimal.class);
        if (globalArpu != null) {
            resultArpu = globalArpu;
        }
        if (resultArpu == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("redis \u4e2d\u672a\u67e5\u8be2\u5230\u9ed8\u8ba4\u7684arpu\u503c\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c\uff0cCPC/OCPC\u521d\u59cb\u5316\u9ed8\u8ba4\u503c\u4e3a0.1\u5143\uff0cCPA\u9ed8\u8ba4\u4e3a0.02\u5143,\u793c\u5238ID\uff1a{}", (Object)ticket.getId());
            }
            resultArpu = ticket.getSettleType() == 2 ? new BigDecimal(0.02) : new BigDecimal(0.1);
        }
        return resultArpu.setScale(7, RoundingMode.HALF_UP);
    }
}

