/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.scheduler.service.impl;

import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.weight.scheduler.service.PriceFloatCalculator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PriceFloatCalculatorImpl
implements PriceFloatCalculator {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    private static KeyGenerator keyGenerator(BigInteger ticketId, String positionId) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("ticketid", ticketId);
        parameters.put("positionid", positionId);
        return TicketKeyGenerator.getTicketPriceFloatPercent((Map)parameters);
    }

    @Override
    public BigDecimal getPf(BigInteger ticketId) {
        KeyGenerator withoutPosition = PriceFloatCalculatorImpl.keyGenerator(ticketId, null);
        BigDecimal floatPercent = (BigDecimal)this.fetcher.fetch(withoutPosition, null, BigDecimal.class);
        return null == floatPercent ? PriceFloatCalculator.DEFAULT : floatPercent;
    }
}

