/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.commons;

import com.bxm.adsprod.weight.commons.OldConfiguration;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={JedisConfiguration.class, OldConfiguration.class})
public class CustomFetcherAutoConfiguration {
    @Autowired
    private JedisConfiguration configuration;
    @Autowired
    private OldConfiguration oldConfiguration;
    @Autowired
    private JedisPool jedisPool;

    @Bean
    public JedisPool jedis2Pool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), 2);
    }

    @Bean
    public Fetcher jedis2Fetcher() {
        return new JedisFetcher(this.jedis2Pool());
    }

    @Bean
    public JedisPool jedisPoolForOld() {
        return new JedisPool((GenericObjectPoolConfig)this.oldConfiguration, this.oldConfiguration.getHost(), this.oldConfiguration.getPort(), this.oldConfiguration.getTimeout(), this.oldConfiguration.getPassword(), this.oldConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherForOld() {
        return new JedisFetcher(this.jedisPoolForOld());
    }

    @Bean
    public JedisUpdater jedisUpdaterForOld() {
        return new JedisUpdater(this.jedisPoolForOld());
    }

    @Bean
    public JedisUpdater jedisUpdater() {
        return new JedisUpdater(this.jedisPool);
    }
}

