package com.bxm.adx.facade.model.position;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * sdk配置请求类<br/>
 *
 * @author zhengwangeng
 * @date 2020/7/1 15:03
 */
@Data
public class SdkConfigRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位ID
     */
    @NotBlank(message = "广告位ID不能为空")
    private String positionId;

    /**
     * 广告位场景
     */
    @NotNull(message = "广告位场景不能为空")
    private Byte positionScene;

    /**
     * 是否是调试，调试只返回变现猫的数据
     */
    private Boolean isDebug;

    /**
     * sdk版本号
     */
    private String sdkv;

    /**
     * 系统类型，1：安卓，2：IOS
     */
    private Integer os;

    /**
     * IMEI，所属安卓
     */
    private String imei;

    /**
     * 安卓ID（androidId），所属安卓10.0以上
     */
    private String anid;

    /**
     * IDFA，所属IOS
     */
    private String idfa;

}
