package com.bxm.adx.facade.model.task;

import java.util.List;

import lombok.Data;

/**
 * 任务信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 11:35
 */
@Data
public class TaskInfo implements java.io.Serializable {

    private static final long serialVersionUID = 9132608548480991005L;
    /**
     * 任务ID
     */
    private Long taskId;
    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务
     */
    private Integer taskType;
    /**
     * 唤醒应用包名
     */
    private String wakePkn;
    /**
     * 唤醒跳转协议
     */
    private String wakeDeepUrl;
    /**
     * 曝光到点击的最大时间间隔，单位：秒
     */
    private Integer viewClkMax;
    /**
     * 唤醒回到桌面的最大时间间隔，单位：秒
     */
    private Integer wakeBackMax;
    /**
     * 下发监测地址
     */
    private List<String> acquireTrackers;
    /**
     * 曝光监测地址
     */
    private List<String> viewTrackers;
    /**
     * 点击监测地址
     */
    private List<String> clickTrackers;
    /**
     * 准备就绪监测地址
     */
    private List<String> readyTrackers;
    /**
     * 唤醒监测地址
     */
    private List<String> wakeTrackers;
    /**
     * 唤醒成功监测地址
     */
    private List<String> succeedTrackers;
}
