package com.bxm.adx.facade.rule.task;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * <p>
 * 任务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
@Data
public class Task implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 开启
     */
    public static final int STATUS_OPEN = 1;
    /**
     * 暂停
     */
    public static final int STATUS_PAUSE = 2;
    /**
     * 停止
     */
    public static final int STATUS_CLOSE = 3;

    /**
     * 1-总曝光限制
     */
    public static final int PAUSE_REASON_VIEW_TOTAL_LIMIT = 1;
    /**
     * 2-日曝光限制
     */
    public static final int PAUSE_REASON_VIEW_DAY_LIMIT = 2;
    /**
     * 3-总点击限制
     */
    public static final int PAUSE_REASON_CLICK_TOTAL_LIMIT = 3;
    /**
     * 4-日点击限制
     */
    public static final int PAUSE_REASON_CLICK_DAY_LIMIT = 4;
    /**
     * 5-人工手动暂停、
     */
    public static final int PAUSE_REASON_MANUAL = 5;
    /**
     * 6-总唤醒限制
     */
    public static final int PAUSE_REASON_WAKE_TOTAL_LIMIT = 6;
    /**
     * 7-日唤醒限制
     */
    public static final int PAUSE_REASON_WAKE_DAY_LIMIT = 7;


    /**
     * ID
     */
    private Long id;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 有效期开始
     */
    private Date startDate;

    /**
     * 有效期结束
     */
    private Date endDate;

    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务
     */
    private Integer type;

    /**
     * 总曝光限制。0表示不限
     */
    private Long viewTotalLimit;

    /**
     * 日曝光限制。0表示不限
     */
    private Long viewDayLimit;

    /**
     * 总点击限制。0表示不限
     */
    private Long clickTotalLimit;

    /**
     * 日点击限制。0表示不限
     */
    private Long clickDayLimit;
    
    /**
     * 总唤醒限制。0表示不限
     */
    private Long wakeUpTotalLimit;

    /**
     * 日唤醒限制。0表示不限
     */
    private Long wakeUpDayLimit;

    /**
     * 曝光点击间隔不超过该值，单位为秒
     */
    private Integer viewClickInterval;

    /**
     * 唤醒回到桌面不超过该值，单位为秒
     */
    private Integer wakeUpToDesktop;

    /**
     * 应用包名
     */
    private String packageName;

    /**
     * 跳转协议
     */
    private String jumpProtocol;

    /**
     * 唤醒检查接口。0:无 、1:腾讯新闻
     */
    private Integer wakeCheckApi;

    /**
     * 下发监测地址，多个用逗号分隔
     */
    private String acquireMonitorUrl;

    /**
     * 曝光监测地址，多个用逗号分隔
     */
    private String viewMonitorUrl;

    /**
     * 点击监测地址，多个用逗号分隔
     */
    private String clickMonitorUrl;

    /**
     * 准备就绪监测地址，多个用逗号分隔
     */
    private String readyMonitorUrl;

    /**
     * 唤醒完成监测地址，多个用逗号分隔
     */
    private String wakeUpMonitorUrl;

    /**
     * 唤醒成功监测地址，多个用逗号分隔
     */
    private String wakeSucceedMonitorUrl;

    /**
     * 操作系统。1-安卓，2-IOS
     */
    private Integer os;

    /**
     * 优先级
     */
    private Integer priority;

    /**
     * 状态。1 正常、2 暂停、3 停止、
     */
    private Integer status;

    /**
     * 暂停原因。1-总曝光限制、2-日曝光限制、3-总点击限制、4-日点击限制、5-人工手动暂停、6-总唤醒限制、7-日唤醒限制
     */
    private Integer pauseReason;

    /**
     * 是否开放中的任务
     */
    public boolean isOpened(){
        return null != status && status == STATUS_OPEN;
    }
}
