package com.bxm.adx.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adx.facade.constant.Constants;
import com.bxm.adx.facade.model.task.TaskInfo;
import com.bxm.adx.facade.model.task.TaskCounter;
import com.bxm.adx.facade.model.task.TaskInfoRequest;

/**
 * 任务信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/25 17:20
 */
@FeignClient(Constants.SERVER_NAME)
public interface TaskService {
    
    /**
     * 获取任务信息<br/>
     *
     * @param request 
     * @return
     */
    @RequestMapping(path = "/taskService/getTask", method = RequestMethod.POST)
    TaskInfo getTask(@RequestBody TaskInfoRequest request);
    
    /**
     * 获取任务信息列表<br/>
     *
     * @param request 
     * @return
     */
    @RequestMapping(path = "/taskService/getTasks", method = RequestMethod.POST)
    List<TaskInfo> getTasks(@RequestBody TaskInfoRequest request);
    
    /**
     * 批量获取任务统计信息<br/>
     *
     * @param idsStr 主键字符串，逗号分隔{@link Constants.SPLIT_COMMA}
     * @return
     */
    @RequestMapping(path = "/taskService/getByIds", method = RequestMethod.GET)
    List<TaskCounter> getByIds(@RequestParam(name = "idsStr") String idsStr);
}
