package com.bxm.adx.facade.model.position;

import java.math.BigDecimal;
import java.util.Objects;

import lombok.Data;

/**
 * 广告位
 * TODO duplicated class com.bxm.adx.common.sell.position.Position
 * @author allen
 * @since 2019-12-16
 */
@Data
public class Position {

    /**
     * 媒介审核
     */
    public static final byte STATUS_MEDIA_AUDIT = 3;
    /**
     * 媒介拒绝
     */
    public static final byte STATUS_MEDIA_REFUSE = 4;
    /**
     * 终审
     */
    public static final byte STATUS_FINAL_AUDIT = 0;
    /**
     * 终审通过
     */
    public static final byte STATUS_FINAL_PASS = 1;
    /**
     * 终审拒绝
     */
    public static final byte STATUS_FINAL_REFUSE = 2;

    /**
     * 关闭
     */
    public static final byte CLOSED_YES = 1;
    /**
     * 未关闭
     */
    public static final byte CLOSED_NO = 0;
    /**
     * 无兜底
     */
    public static final int FALLBACK_STRATEGY_NONE = 1;
    /**
     * 组件兜底
     */
    public static final int FALLBACK_STRATEGY_ASSEMBLY = 2;

    ///**
    // * 信息流
    // */
    //public static final byte POSITION_SCENE_INFORMATION_FLOW = 1;
    ///**
    // * 开屏
    // */
    //public static final byte POSITION_SCENE_BOOT = 2;
    ///**
    // * banner
    // */
    //public static final byte POSITION_SCENE_BANNER = 3;
    ///**
    // * 插屏
    // */
    //public static final byte POSITION_SCENE_SCREEN = 4;
    ///**
    // * 浮标
    // */
    //public static final byte POSITION_SCENE_ICON = 5;
    ///**
    // * 按钮
    // */
    //public static final byte POSITION_SCENE_BUTTON = 6;
    ///**
    // * 搜索
    // */
    //public static final byte POSITION_SCENE_SEARCH = 7;
    ///**
    // * 激励视频
    // */
    //public static final byte POSITION_SCENE_INSPIRE_VIDEO = 8;
    ///**
    // * 视频
    // */
    //public static final byte POSITION_SCENE_VIDEO = 9;

    /**
     * appid(Code)
     */
    private String appId;
    private String positionId;
    private String appPositionId;
    private Byte status;
    /**
     * 媒体底价
     */
    private BigDecimal basePrice;

    /**
     * 是否已关闭：1 表示已关闭，0 表示未关闭
     */
    private Byte closedFlag;

    /**
     * 广告位场景：由于有太多，还可能会增加，这里不再列举，请从ssp后台查看对应枚举
     */
    private Byte positionScene;

    /**
     * 信息流模板，这里不再列举，请从ssp后台查看对应枚举
     */
    private Integer informationFlowTemplate;

    /**
     * 屏蔽规则ID,多个用逗号分隔
     */
    private String shieldStrategyIds;
    /**
     * 兜底策略：1无兜底，2组件兜底
     */
    private Integer fallbackStrategy;

    /*************************************** 广告位不同类型的尺寸 ***************************************/
    /**
     * 封面图约束 {type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
     */
    private String coverPictureConstraints;

    /**
     * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
     */
    private String iconConstraints;

    /**
     * 大图尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
     */
    private String largeSizeConstraints;

    /**
     * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
     */
    //这个是 图片 和 原生视频 共有的
    private String pictureConstraints;


    /**
     * 每天每人限推送次数
     */
    private Integer pushTimesPerPersonPerDay;

    /**
     * 推送展示停留时间，单位为秒
     */
    private Integer pushShowStayTime;

    /**
     * 推送间隔时间，单位为分钟
     */
    private Integer pushIntervalTime;

    /**
     * SDK初始化多少秒后开始推送
     */
    private Integer sdkInitIntervalTime;


    /**
     * @return 是否审核通过，并且没有关闭才允许放量
     */
    public boolean isEnabled() {
        return (null != status && status == STATUS_FINAL_PASS) && (null != closedFlag && closedFlag == CLOSED_NO);
    }

    /**
     * @return 是否组件兜底
     */
    public boolean isRevealBottomAssembly() {
        return Objects.equals(status, STATUS_FINAL_PASS) && Objects.equals(closedFlag, CLOSED_NO)
                && Objects.equals(fallbackStrategy, FALLBACK_STRATEGY_ASSEMBLY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Position position = (Position) o;
        return Objects.equals(positionId, position.positionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(positionId);
    }
}
