package com.bxm.adx.facade.rule.app;

import java.io.Serializable;
import java.util.Objects;

import lombok.Data;

/**
 * 推送模型-开发者应用<br/>
 *
 * @author kerry.jiang
 * @date 2020/5/29 17:43
 */
@Data
public class App implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;
    /**
     * AppID
     */
    private String appId;
    /**
     * 审核状态：0 风控终审，1 终审通过，2 终审拒绝，3 媒介初审，4 初审拒绝
     */
    private Integer status;
    /**
     * 是否逻辑删除：1 表示删除，0 表示未删除
     */
    private Integer deleted;
    /**
     * 是否开启耍呗：1-开启，0-关闭
     */
    private Integer flourished;

    /**
     * 应用包名
     */
    private String appPackageName;

    /**
     * 应用下推送场景的广告位positionId
     */
    private String pushScenePositionId;

    /**
     * 是否开启任务
     */
    public boolean isOpenTask(){
        return Objects.equals(status, 1) &&
                Objects.equals(deleted, 0) &&
                Objects.equals(flourished, 1);
    }
}