package com.bxm.adx.facade.rule.task;

import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;

/**
 * 任务设备品牌黑白名单规则<br/>
 * <pre>
 *     {type}-{deviceBrand},{deviceBrand},{deviceBrand}
 *     
 *     {type} => 类型。1- 白名单、2- 黑名单
 *     {deviceBrand} => 设备品牌名
 * </pre>
 *
 * @author kerry.jiang
 * @date 2020/6/1 10:08
 */
public class TaskDeviceBrandRuleSo extends RuleSo {

    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDeviceBrandRuleSo.class);

    public static final String TYPE_WHITELIST = "1";
    public static final String TYPE_BLACKLIST = "2";

    private static final int VALUE_SPLIT_SIZE = 2;

    /**
     * 是否为黑名单
     */
    @JSONField(deserialize = false, serialize = false)
    private boolean blackList;
    /**
     * 设备品牌名，全小写
     */
    @JSONField(deserialize = false, serialize = false)
    private Set<String> deviceBrands = Sets.newHashSet();

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();
        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] strings = StringUtils.split(value, '-');
        if (strings.length < VALUE_SPLIT_SIZE) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid value format of 'TaskDeviceBrandRuleSo', {}.", value);
            }
            return;
        }
        if (strings.length > VALUE_SPLIT_SIZE) {
            int startIndex = value.indexOf('-');
            strings = new String[2];
            strings[0] = StringUtils.substring(value, 0, startIndex);
            strings[1] = StringUtils.substring(value, startIndex + 1, value.length());
        }

        String type = strings[0];
        String deviceBrands = strings[1];

        this.blackList = (StringUtils.equals(TYPE_BLACKLIST, type));
        String[] deviceBrandArray = StringUtils.split(deviceBrands, ',');

        for (String s : deviceBrandArray) {
            this.deviceBrands.add(s.toLowerCase());
        }
    }

    public boolean isBlackList() {
        return blackList;
    }


    public Set<String> getDeviceBrands() {
        return deviceBrands;
    }
}
