/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.facade.rule.task;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adx.facade.rule.task.RuleSo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTimeSlotRuleSo
extends RuleSo {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTimeSlotRuleSo.class);
    private static final int VALUE_SPLIT_SIZE = 7;
    private static final int BINARY_BIT = 24;
    private static final String BINARY_ZERO = "0";
    @JSONField(deserialize=false, serialize=false)
    private Map<Integer, Map<Integer, Boolean>> weekTimeSlot = new HashMap<Integer, Map<Integer, Boolean>>();

    public Map<Integer, Map<Integer, Boolean>> getWeekTimeSlot() {
        return this.weekTimeSlot;
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);
        String value = super.getRuleValue();
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        String[] dayTimeArray = StringUtils.split((String)value, (char)',');
        if (dayTimeArray.length < 7) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid value format of 'TaskTimeSlotRuleSo', {}.", (Object)value);
            }
            return;
        }
        int dayIndex = -1;
        for (String dayTime : dayTimeArray) {
            Long timeDecimal;
            String binary;
            int repairNum;
            Map<Integer, Boolean> timeSlot;
            if (null == (timeSlot = this.weekTimeSlot.get(++dayIndex))) {
                timeSlot = new HashMap<Integer, Boolean>();
                this.weekTimeSlot.put(dayIndex, timeSlot);
            }
            if ((repairNum = 24 - (binary = Long.toBinaryString(timeDecimal = Long.valueOf(dayTime))).length()) > 0) {
                StringBuilder binaryBuilder = new StringBuilder();
                for (int i = 0; i < repairNum; ++i) {
                    binaryBuilder.append(BINARY_ZERO);
                }
                binaryBuilder.append(binary);
                binary = binaryBuilder.toString();
            }
            char[] chars = binary.toCharArray();
            int hourIndex = -1;
            for (char c : chars) {
                timeSlot.put(++hourIndex, c == '1');
            }
        }
    }
}

