/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.facade.constant.enums;

import java.util.Arrays;
import java.util.Objects;

public enum AdxErrEnum {
    APP_INFO_ERR("app verify err", 401),
    DSP_TIMEOUT("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40003),
    DISPATCHER_ERR("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40004),
    POSITION_FILTER("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40005),
    DSP_EMPTY_RESPONSE("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40006),
    ADX_EMPTY_RESPONSE("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40007),
    POSITION_NOT_FOUND("position not found", 40010),
    POSITION_SCENE_MISMATCH("position scene mismatch", 40011),
    POSITION_OS_MISMATCH("position os mismatch", 40012),
    SCENE_CONFIG_EMPTY("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40021),
    SCENE_ACTIVITY_EMPTY("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40022),
    SCENE_ASSET_EMPTY("\u83b7\u53d6\u5e7f\u544a\u5931\u8d25", 40023),
    UNKNOWN_ERR("unknown err", 40099),
    PLUGIN_ERR("media plugin err", 40030);

    private String msg;
    private Integer result;

    private AdxErrEnum(String msg, Integer result) {
        this.msg = msg;
        this.result = result;
    }

    public String getMsg() {
        return this.msg;
    }

    public Integer getResult() {
        return this.result;
    }

    @Deprecated
    public static AdxErrEnum getAdxErrByResult(Integer result) {
        if (Objects.isNull(result)) {
            return UNKNOWN_ERR;
        }
        return Arrays.stream(AdxErrEnum.values()).filter(adxErrEnum -> adxErrEnum.result.intValue() == result.intValue()).findFirst().orElse(UNKNOWN_ERR);
    }
}

