package com.bxm.adx.facade.constant.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * Created by Arei on 2020/12/15.
 */
public enum AdxErrEnum {
    /**
     * App Verify Error
     */
    APP_INFO_ERR("app verify err", 401),

    DSP_TIMEOUT("获取广告失败", 40003),
    DISPATCHER_ERR("获取广告失败", 40004),
    POSITION_FILTER("获取广告失败", 40005),
    DSP_EMPTY_RESPONSE("获取广告失败", 40006),
    ADX_EMPTY_RESPONSE("获取广告失败", 40007),

    POSITION_NOT_FOUND("position not found", 40010),
    POSITION_SCENE_MISMATCH("position scene mismatch", 40011),
    POSITION_OS_MISMATCH("position os mismatch", 40012),

    SCENE_CONFIG_EMPTY("获取广告失败", 40021),
    SCENE_ACTIVITY_EMPTY("获取广告失败", 40022),
    SCENE_ASSET_EMPTY("获取广告失败", 40023),

    CREATIVE_NOT_FOUND("creative not found", 40031),

    UNKNOWN_ERR("unknown err", 40099),

    PLUGIN_ERR("media plugin err", 40030),
    ;

    private String msg;
    private Integer result;

    AdxErrEnum(String msg, Integer result) {
        this.msg = msg;
        this.result = result;
    }

    public String getMsg() {
        return msg;
    }

    public Integer getResult() {
        return result;
    }

    @Deprecated
    public static AdxErrEnum getAdxErrByResult(Integer result) {
        if (Objects.isNull(result)) {
            return AdxErrEnum.UNKNOWN_ERR;
        }
        return Arrays.stream(AdxErrEnum.values())
                .filter(adxErrEnum -> adxErrEnum.result == result.intValue())
                .findFirst()
                .orElse(AdxErrEnum.UNKNOWN_ERR);
    }
}

