package com.bxm.adx.facade.rule.task;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 任务频次规则<br/>
 * <pre>
 *     {cycle}-{type}-{count},{cycle}-{type}-{count}...
 *
 *     {cycle} => 周期。1：每天
 *     {type} => 类型。1：曝光，2：点击，3：唤醒
 *     {positionId} => 次数
 * </pre>
 * 
 * @author kerry.jiang
 * @date 2020/3/26 19:42
 */
public class TaskFrequencyRuleSo extends AbstractThreeRule {

    @JSONField(deserialize = false, serialize = false)
    private List<Entry> entries = Lists.newArrayList();

    @Override
    protected void addItem(int one, int two, long three) {
        this.entries.add(new Entry(one, two, three));
    }

    public List<Entry> getEntries() {
        return entries;
    }

    public static class Entry {

        public static final int CYCLE_EVERYDAY = 1;

        public static final int TYPE_VIEW = 1;
        public static final int TYPE_CLICK = 2;
        public static final int TYPE_WAKE = 3;

        /**
         * 周期。1：每天
         */
        private int cycle;
        /**
         * 类型。1：曝光，2：点击，3：唤醒
         */
        private int type;
        /**
         * 次数
         */
        private long count;

        public Entry(int cycle, int type, long count) {
            this.cycle = cycle;
            this.type = type;
            this.count = count;
        }

        public int getCycle() {
            return cycle;
        }

        public void setCycle(int cycle) {
            this.cycle = cycle;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public long getCount() {
            return count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }

}
