package com.bxm.adx.common;

/**
 * @author allen
 * @since 2019-12-16
 */
public class AdxConstants {


    public static final byte YES = 1;
    public static final byte NO = 0;

    public static final int  ADX_REQ= 15001;
    public static final int  ADX_RESP= 15104;
    public static final int  DSP_REQ= 15002;
    public static final int  DSP_RESP= 15103;
    /**
     * 广告创意类型
     */
    public enum Type {
        NATIVE(1),
        IMAGE(2),
        VIDEO(3),
        TEXT(4),
        INSPIRE_VIDEO(5);
        private Integer type;

        Type(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }

        public static Integer getTypeByPositionScene(Byte scene) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get(scene.intValue());
            if (sceneTypeEnum == null) {
                return null;
            }
            switch (sceneTypeEnum) {
                case INFORMATION_FLOW:
                    return NATIVE.getType();
                case BOOT:
                    return IMAGE.getType();
                case SCREEN:
                    return IMAGE.getType();
                case BUTTON:
                    return IMAGE.getType();
                case INFORMATION_FLOW_SELF_RENDERING:
                    return NATIVE.getType();
                case BANNER:
                    return IMAGE.getType();
                case ICON:
                    return IMAGE.getType();
                case VIDEO:
                    return VIDEO.getType();
                case INSPIRE_VIDEO:
                    return INSPIRE_VIDEO.getType();
                case SELF_RENDERING:
                    return NATIVE.getType();
                case INFORMATION_FLOW_IMMERSIVE_VIDEO:
                    return VIDEO.getType();

            }
            return null;
        }
    }

    public enum Action {
        UNKNOW(0),
        DOWNLOAD_ANDROID(2),
        DOWNLOAD_IOS(3),
        WEB_VIEW(6),
        DEEP_LINK(9);
        private int action;

        Action(int action) {
            this.action = action;
        }

        public int getAction() {
            return action;
        }
    }

    public enum ActivityErr {
        DOUDI,
        MEI_DOU_ZHU
    }

    public enum CounterMt {
        IMP("1"),
        CLICK("2"),

        V_START("3"),
        V_1_4("4"),
        V_1_2("5"),
        V_3_4("6"),
        V_END("7"),
        V_MUTE("8"),
        V_SKIP("9"),
        V_CLOSED("10"),
        V_SUSPEND("11"),
        V_PROCEED("12"),
        V_BAD_NET("18"),
        V_FULL_SCREEN_PLAY("19"),
        V_CLOSE_FULL_SCREEN_PLAY("20"),
        V_CLOSE_MUTE_PLAY("21"),

        APP_D_START("13"),
        APP_D_END("14"),
        APP_IN_START("15"),
        APP_IN_END("16"),
        APP_ACT("22"),

        DP_START("23"),
        DP_SUCCESS("24"),
        DP_FAIL("25"),
        ;
        private String mt;

        CounterMt(String mt) {
            this.mt = mt;
        }

        public String getMt() {
            return mt;
        }
    }
}
