package com.bxm.adx.common;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author allen
 * @since 2019-12-18
 */
public class CacheKeys {
    public static KeyGenerator getBidRequestKeyGenerator (String bidid) {
        return () -> KeyBuilder.build("ADX", "POSITION", "SCENE", "BIDREQUEST", bidid);
    }

    public static KeyGenerator getActivityErrGenerator (String positionId, String type) {
        return () -> KeyBuilder.build("ADX", "SCENE", "ACTIVITY", positionId, type);
    }

    public static KeyGenerator getDspRequestCount (String dspId) {
        return () -> KeyBuilder.build("ADX", "DSP", "COUNT", "REQ", dspId);
    }

    public static KeyGenerator getDspResponseCount (String dspId) {
        return () -> KeyBuilder.build("ADX", "DSP", "COUNT", "RESP", dspId);
    }
}
