package com.bxm.adx.common;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by Arei on 2020/10/9.
 */
@ControllerAdvice
@Slf4j
public class ExceptionAdvice  {
    @ExceptionHandler(AdxException.class)
    @ResponseBody
    public ResponseEntity<String> handleException(AdxException ex) {
        if (log.isErrorEnabled()) {
            log.error(ex.getMessage());
        }
        ResponseEntity entity = new ResponseEntity(HttpStatus.resolve(ex.getCode()));
        return entity;
    }
}
