package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.*;
import com.bxm.adx.common.sell.ssp.resp.AppTracker;
import com.bxm.adx.common.sell.ssp.resp.DpTracker;
import com.bxm.adx.common.sell.ssp.resp.VMonitor;
import com.bxm.adx.common.utils.UrlUtils;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.web.util.TextEncrypted;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Arei on 2020/11/5.
 */
@Component
@Slf4j
public class ConcreteMonitorBuilder extends MonitorBuilder {
    private TextEncrypted textEncrypted;

    public ConcreteMonitorBuilder(TextEncrypted textEncrypted) {
        this.textEncrypted = textEncrypted;
    }

    @Override
    public VMonitor fillVMonitor(VMonitor vm, String url, AdxCounterParam param) {
        List<String> vCloseUrls = vm.getV_close_urls();
        if (null == vCloseUrls) {
            vCloseUrls = new ArrayList<>();
        }
        vCloseUrls.add( replace(url, param, AdxConstants.CounterMt.V_CLOSED));
        vm.setV_close_urls(vCloseUrls);

        List<String> vEndUrls = vm.getV_end_urls();
        if (null == vEndUrls) {
            vEndUrls = new ArrayList<>();
        }
        vEndUrls.add(replace(url, param, AdxConstants.CounterMt.V_END));
        vm.setV_end_urls(vEndUrls);

        List<String> vHalfUrls = vm.getV_half_urls();
        if (null == vHalfUrls) {
            vHalfUrls = new ArrayList<>();
        }
        vHalfUrls.add(replace(url, param, AdxConstants.CounterMt.V_1_2));
        vm.setV_half_urls(vHalfUrls);

        List<String> vMuteUrls = vm.getV_mute_urls();
        if (null == vMuteUrls) {
            vMuteUrls = new ArrayList<>();
        }
        vMuteUrls.add(replace(url, param, AdxConstants.CounterMt.V_MUTE));
        vm.setV_mute_urls(vMuteUrls);

        List<String> vProceedUrls = vm.getV_proceed_urls();
        if (null == vProceedUrls) {
            vProceedUrls = new ArrayList<>();
        }
        vProceedUrls.add(replace(url, param, AdxConstants.CounterMt.V_PROCEED));
        vm.setV_proceed_urls(vProceedUrls);

        List<String> vQuarterUrls = vm.getV_quarter_urls();
        if (null == vQuarterUrls) {
            vQuarterUrls = new ArrayList<>();
        }
        vQuarterUrls.add(replace(url, param, AdxConstants.CounterMt.V_1_4));
        vm.setV_quarter_urls(vQuarterUrls);

        List<String> vSkipUrls = vm.getV_skip_urls();
        if (null == vSkipUrls) {
            vSkipUrls = new ArrayList<>();
        }
        vSkipUrls.add(replace(url, param, AdxConstants.CounterMt.V_SKIP));
        vm.setV_skip_urls(vSkipUrls);

        List<String> vStartUrls = vm.getV_start_urls();
        if (null == vStartUrls) {
            vStartUrls = new ArrayList<>();
        }
        vStartUrls.add(replace(url, param, AdxConstants.CounterMt.V_START));
        vm.setV_start_urls(vStartUrls);

        List<String> vSuspendUrls = vm.getV_suspend_urls();
        if (null == vSuspendUrls) {
            vSuspendUrls = new ArrayList<>();
        }
        vSuspendUrls.add(replace(url, param, AdxConstants.CounterMt.V_SUSPEND));
        vm.setV_suspend_urls(vSuspendUrls);

        List<String> vThreeQuarterUrls = vm.getV_three_quarter_urls();
        if (null == vThreeQuarterUrls) {
            vThreeQuarterUrls = new ArrayList<>();
        }
        vThreeQuarterUrls.add(replace(url, param, AdxConstants.CounterMt.V_3_4));
        vm.setV_three_quarter_urls(vThreeQuarterUrls);

        List<String> vBadNetUrls = vm.getV_bad_net_urls();
        if (null == vBadNetUrls) {
            vBadNetUrls = new ArrayList<>();
        }
        vBadNetUrls.add(replace(url, param, AdxConstants.CounterMt.V_BAD_NET));
        vm.setV_bad_net_urls(vBadNetUrls);

        return vm;
    }

    @Override
    public List<String> fillClickMonitor(List<ClickMonitor> clickMonitors, String baseUrl, AdxCounterParam param) {
        List<String> curls = null;
        if (!CollectionUtils.isEmpty(clickMonitors)) {
            curls = clickMonitors.stream().map(ClickMonitor::getClick_monitor_url).collect(Collectors.toList());

        }
        if (null == curls) {
            curls = new ArrayList<>();
        }
        curls.add(replace(baseUrl, param, AdxConstants.CounterMt.CLICK));
        return curls;
    }

    @Override
    public List<String> fillImpMonitor(List<ImpMonitor> impMonitors, String baseUrl, AdxCounterParam param) {
        List<String> iurls = null;
        if (!CollectionUtils.isEmpty(impMonitors)) {
            iurls = impMonitors.stream().map(ImpMonitor::getImp_monitor_url).collect(Collectors.toList());
        }
        if (null == iurls) {
            iurls = new ArrayList<>();
        }
        String iurl = replace(baseUrl, param, AdxConstants.CounterMt.IMP);
//                iurl = iurl + "&win="+ bid.getPrice_str();

        iurls.add(iurl);
        return iurls;
    }

    @Override
    public DpTracker fillDpMonitor(DpMonitor dpMonitor, String baseUrl, AdxCounterParam param) {
        DpTracker dpTracker = new DpTracker();
        List<String> asUrls = dpMonitor == null ? null : dpMonitor.getAwk_start_urls();
        if (null == asUrls) {
            asUrls = new ArrayList<>();
        }
        asUrls.add(replace(baseUrl, param, AdxConstants.CounterMt.DP_START));
        dpTracker.setAwk_start_urls(asUrls);

        List<String> scUrls = dpMonitor == null ? null : dpMonitor.getAwk_success_urls();
        if (null == scUrls) {
            scUrls = new ArrayList<>();
        }
        scUrls.add(replace(baseUrl, param, AdxConstants.CounterMt.DP_SUCCESS));
        dpTracker.setAwk_success_urls(scUrls);

        List<String> afUrls = dpMonitor == null ? null : dpMonitor.getAwk_fail_urls();
        if (null == afUrls) {
            afUrls = new ArrayList<>();
        }
        afUrls.add(replace(baseUrl, param, AdxConstants.CounterMt.DP_FAIL));
        dpTracker.setAwk_fail_urls(afUrls);
        return dpTracker;
    }

    @Override
    public AppTracker fillAppTracker(AppMonitor appMonitor, String url, AdxCounterParam param) {

        AppTracker appTracker = new AppTracker();
        List<String> dfUrls = appMonitor == null ? null : appMonitor.getDf_urls();
        if (null == dfUrls) {
            dfUrls = new ArrayList<>();
        }
        dfUrls.add(replace(url, param, AdxConstants.CounterMt.APP_D_END));
        appTracker.setDf_urls(dfUrls);

        List<String> dsUrls = appMonitor == null ? null : appMonitor.getDs_urls();
        if (null == dsUrls) {
            dsUrls = new ArrayList<>();
        }
        dsUrls.add(replace(url, param, AdxConstants.CounterMt.APP_D_START));
        appTracker.setDs_urls(dsUrls);

        List<String> ssUrls = appMonitor == null ? null : appMonitor.getSs_urls();
        if (null == ssUrls) {
            ssUrls = new ArrayList<>();
        }
        ssUrls.add(replace(url, param, AdxConstants.CounterMt.APP_IN_START));
        appTracker.setSs_urls(ssUrls);

        List<String> sfUrls = appMonitor == null ? null : appMonitor.getSf_urls();
        if (null == sfUrls) {
            sfUrls = new ArrayList<>();
        }
        sfUrls.add(replace(url, param, AdxConstants.CounterMt.APP_IN_END));
        appTracker.setSf_urls(sfUrls);
        return appTracker;
    }

    private String replace(String url, AdxCounterParam param, AdxConstants.CounterMt mt) {
        if (mt == null) {
            if (log.isErrorEnabled()) {
                log.error("mt is null");
            }
        } else {
            param.setMt(mt.getMt());
        }
        param.setTimestamp(System.currentTimeMillis()+"");
        if (log.isDebugEnabled()) {
            log.debug(UrlUtils.splicingCounterUrl(url, param));
        }
        return textEncrypted.genGetUrl(2, UUIDHelper.generate(), UrlUtils.splicingCounterUrl(url, param));
    }
}
