package com.bxm.adx.common.buy.buyers;

import com.bxm.adx.common.buy.Buyer;
import com.google.common.collect.Maps;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

import java.util.Map;

/**
 * 抽象的，从 ApplicationContext 获取卖家实现。
 * @author allen
 * @since 2019-12-13
 */
public abstract class AbstractContainerBuyersImpl implements Buyers, ApplicationListener<ApplicationReadyEvent> {

    private final Map<String, Buyer> buyers = Maps.newHashMap();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, Buyer> beans = applicationContext.getBeansOfType(Buyer.class);
        for (Map.Entry<String, Buyer> entry : beans.entrySet()) {
            buyers.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, Buyer> getAllBuyers() {
        return buyers;
    }
}
