package com.bxm.adx.common.market;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Sets;
import lombok.Data;

import java.util.Collection;
import java.util.Set;

/**
 * 一次交易市场的请求信息，包含多个买家和多个卖家。
 * @author allen
 * @since 2019-12-17
 */
@Data
public class MarketRequest {

    private int priority;
    /**
     * 买家列表，这些买家同时竞价
     */
    private Set<Buyer> buyers = Sets.newHashSet();
    /**
     * 卖家信息，已关联这些买家
     */
    private Set<Position> positions = Sets.newHashSet();

    public MarketRequest(int priority) {
        this.priority = priority;
    }

    public void addBuyer(Buyer buyer) {
        this.buyers.add(buyer);
    }

    public void addBuyers(Collection<Buyer> buyers) {
        this.buyers.addAll(buyers);
    }

    public void addPosition(Position position) {
        this.positions.add(position);
    }
}
