package com.bxm.adx.common.utils;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import org.springframework.util.StringUtils;

/**
 * Created by Arei on 2020/11/2.
 * adx（插件用）工具类
 */
public class AdxUtils {
    /**
     * 从BidRequest中获取用户id
     * @param request
     * @return
     */
    public static String getUid(BidRequest request) {
        Device device = request.getDevice();
        if (null != device) {
            String imei = device.getImei();
            String imeiMD5 = device.getImei_md5();
            String idfa = device.getIdfa();
            String idfaMD5 = device.getIdfa_md5();
            String dpid = device.getDpid();
            String dpidMD5 = device.getDpid_md5();
            if (!StringUtils.isEmpty(imei)) {
                return imei;
            }
            if (!StringUtils.isEmpty(imeiMD5)) {
                return imeiMD5;
            }
            if (!StringUtils.isEmpty(idfa)) {
                return idfa;
            }
            if (!StringUtils.isEmpty(idfaMD5)) {
                return idfaMD5;
            }
            if (!StringUtils.isEmpty(dpid)) {
                return dpid;
            }
            if (!StringUtils.isEmpty(dpidMD5)) {
                return dpidMD5;
            }
            return null;
        } else {
            return null;
        }
    }


    public static String getImei(Device device) {
        if (null != device) {
            if (StringUtils.isEmpty(device.getImei())) {
                return device.getImei_md5();
            } else {
                return device.getImei();
            }
        } else {
            return null;
        }
    }

    public static String getIdfa(Device device) {
        if (null != device) {
            if (StringUtils.isEmpty(device.getIdfa())) {
                return device.getIdfa_md5();
            } else {
                return device.getIdfa();
            }
        } else {
            return null;
        }
    }
}
