package com.bxm.adx.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by Arei on 2020/10/9.
 */
@ControllerAdvice
@Slf4j
public class ExceptionAdvice  {
    private final ObjectMapper objectMapper;

    public ExceptionAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public ResponseEntity<String> handleException(Exception ex) {
        if (log.isErrorEnabled()) {
            log.error("catch error", ex);
        }
        ObjectNode objectNode = objectMapper.createObjectNode();
        HttpStatus status = HttpStatus.OK;
        if (ex instanceof AdxException) {
            AdxException adxException = (AdxException) ex;
            status = HttpStatus.resolve(adxException.getCode());
            if (adxException.getResult() != null) {
                objectNode.put("result", adxException.getResult());
                objectNode.put("msg", adxException.getMessage());
            }
        }

        ResponseEntity entity = new ResponseEntity(objectNode, status);
        return entity;
    }
}
