package com.bxm.adx.common;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author allen
 * @since 2019-12-18
 */
public class CacheKeys {
    public static KeyGenerator getBidRequestKeyGenerator (String bidid) {
        return () -> KeyBuilder.build("ADX", "POSITION", "SCENE", "BIDREQUEST", bidid);
    }

    public static KeyGenerator getActivityErrGenerator (String positionId, String type) {
        return () -> KeyBuilder.build("ADX", "SCENE", "ACTIVITY", positionId, type);
    }

    public static KeyGenerator getDspRequestCount (String dspId) {
        return () -> KeyBuilder.build("ADX", "DSP", "COUNT", "REQ", dspId);
    }

    public static KeyGenerator getDspResponseCount (String dspId) {
        return () -> KeyBuilder.build("ADX", "DSP", "COUNT", "RESP", dspId);
    }

    public static KeyGenerator getDspNowQPS (String time) {
        return () -> KeyBuilder.build("ADX", "DSP", "QPS", time);
    }

    public static KeyGenerator getDspQPSBan (String time) {
        return () -> KeyBuilder.build("ADX", "DSP", "QPS", "BAN", time);
    }

    public static KeyGenerator getPackageNameKey () {
        return () -> KeyBuilder.build("ADX", "PACKAGENAME", "VERIFY");
    }

    public static KeyGenerator getClickMacroDsp () {
        return () -> KeyBuilder.build("ADX", "DSP", "MACRO", "CLICK");
    }

    public static KeyGenerator getVideoMacroDsp () {
        return () -> KeyBuilder.build("ADX", "DSP", "MACRO", "VIDEO");
    }

    public static class Dispather {

        public static KeyGenerator getKeyGenerator(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "PID_AB", positionId);
        }

        public static KeyGenerator getKeyGeneratorByAppPosId(String appPosId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "APPID_AB", appPosId);
        }

        public static KeyGenerator getKeyGeneratorByBucketing(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "BUCKETING_AB", positionId);
        }

        public static KeyGenerator getKeyGeneratorByAll(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "ALL_AB", positionId);
        }

        public static KeyGenerator getDispatcherKeyGeneratorByUid(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "USER_AB", positionId);
        }
    }
}
