package com.bxm.adx.common;

/**
 * <p>
 * 广告位SDK配置渠道枚举
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-16
 */
public enum PositionSdkConfigChannelEnum {

    BXM("bxm_channel", "变现猫", "3"),

    CSJ("csj_channel", "穿山甲", "1"),

    //MOBVISTA("mobvista_channel", "mobvista"),

    GDT("gdt_channel", "广点通", "2"),

    BD("bd_channel", "百度", "6"),

    APP("app_channel", "本地客户端", "4"),

    KS("ks_channel", "快手", "7"),

    BACKUP("backup_channel", "变现猫兜底", "5"),

    AD("ad_channel", "爱豆", "8")
    ;


    private String code;

    private String name;

    /**
     * 数据中心的类型值
     */
    private String dateChannelView;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getDateChannelView() {
        return dateChannelView;
    }

    PositionSdkConfigChannelEnum(String code, String name, String dateChannelView) {
        this.code = code;
        this.name = name;
        this.dateChannelView = dateChannelView;
    }

    public static PositionSdkConfigChannelEnum get(String code) {
        if (null == code) {
            return null;
        }
        for (PositionSdkConfigChannelEnum anEnum : values()) {
            if (anEnum.getCode().equals(code)) {
                return anEnum;
            }
        }
        return null;
    }
}
