package com.bxm.adx.common.sell.ssp.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

import java.util.List;

/**
 * Created by Arei on 2020/1/17.
 */
@lombok.Data
public class Ad {
    private String id;
    private String place_token;
    private Integer action;
    private Integer w;
    private Integer h;
    private String app_bundle;
    private String apk_name;
    private String app_ver;
    private String deeplink_url;
    private String target_url;
    private List<String> click_trackers;
    private List<String> imp_trackers;
    @JSONField(alternateNames = {"appTracker", "app_tracker", "app_trackers"})
    private AppTracker appTracker;
    private DpTracker dp_tracker;
    private Integer type;
    private Float price;
    @JSONField(name = "native")
    private Native a_native;
    private Integer template;
    private String ext;
    private Integer web_view_countdown = 3;
    private Config config;
    /**
     * 曝光、点击失败情况下需要处理的数据。
     */
    private Fail fail;
    /**
     * 广告平台标识，和dspid强关联，但是区分于dspid
     * 现仅用于标识是否来自优量汇
     */
    private Integer dsp_platform;
}
