package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.buy.dsp.Dsp;

import java.util.Collection;
import java.util.Map;

/**
 * 分发服务
 *
 * @author allen
 * @since 2019-12-16
 */
public interface DispatcherService {

    /**
     * 根据广告位获取有优先级的买方信息。
     * Key = 优先级
     * Value = 分配的DSP平台列表
     * @param positionId 广告位
     * @return 分发配置
     */
    Map<Integer, Collection<Dsp>> getPriority(String positionId);

    /**
     * 根据广告位获取分发配置。
     * @param positionId 广告位
     * @return 分发配置
     */
    Collection<Dispatcher> get(String positionId);

    /**
     * 查找媒体广告位ID与DSP code的分发配置
     * @param appPosId 媒体广告位ID
     * @param dspCode DSP code
     * @return 分发配置
     */
    Dispatcher getByAppPosId(String appPosId, String dspCode);

    /**
     * 查找广告位ID与DSP ID的分发配置
     * @param positionId 广告位ID
     * @param dspId DSP ID
     * @return 分发配置
     */
    Dispatcher get(String positionId, String dspId);
}
