package com.bxm.adx.common.buy.dsp;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * For cache pushable
 *
 * <pre>
 *     name = "DSP"
 *     parameters = {}
 *     byte[] = Dsp object to json bytes
 * </pre>
 * @author allen
 * @since 2019-12-18
 */
@CachePush("DSP")
@Component
public class DspDaoImpl implements DspDao, Pushable, ApplicationContextAware {

    private final Fetcher fetcher;
    private final Updater updater;

    private ApplicationContext applicationContext;

    public DspDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Collection<Dsp> getAll() {
        return fetcher.hfetchall(getKeyGenerator(), Dsp.class).values();
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Dsp dsp = JsonHelper.convert(data, Dsp.class);
        Long id = dsp.getId();
        updater.hupdate(getKeyGenerator(), Objects.toString(id), dsp);
        applicationContext.publishEvent(new DspChangedEvent(this, dsp));
    }

    private KeyGenerator getKeyGenerator() {
        return () -> KeyBuilder.build("ADX", "DSPS");
    }
}
