package com.bxm.adx.common.ingetration.feign;

import com.bxm.adx.common.ingetration.TaskServiceIntegration;
import com.bxm.adx.facade.model.task.TaskCounter;
import com.bxm.adx.facade.model.task.TaskInfo;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.service.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import java.util.List;

/**
 * @author allen
 * @date 2020-11-17
 * @since 1.0
 */
@Configuration
@Profile("!standalone")
@EnableFeignClients(basePackages = {"com.bxm.adx.facade"})
public class FeignTaskServiceIntegrationImpl implements TaskServiceIntegration {

    @Autowired
    private TaskService taskService;

    @Override
    public TaskInfo getTask(TaskInfoRequest request) {
        return taskService.getTask(request);
    }

    @Override
    public List<TaskInfo> getTasks(TaskInfoRequest request) {
        return taskService.getTasks(request);
    }

    @Override
    public List<TaskCounter> getByIds(String idsStr) {
        return taskService.getByIds(idsStr);
    }
}
