package com.bxm.adx.common.sell.response;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Accessors(chain = true)
public class Asset implements Serializable {
    /**
     * ⼴告元素ID
     */
    private String id;
    /**
     * ⼴告元素是否必须填，1：必须，0：可选
     */
    private Integer required;
    /**
     * Asset类型。原⽣⼴告元素列表，当前固定为12个元素，分别为:
     * <pre>
     * 0、未知
     * 1、标题（text）
     * 2、内容（text）
     * 3、按钮⽂本（text）
     * 4、按钮内容（text）
     * 5、price（text）
     * 6、icon（img）
     * 7、Large_image （img）
     * 8、button_image（img）
     * 9、Description（data）
     * 10、Rating（data）
     * 11、video（video）
     * 12、Rewarded_Video(video)
     * </pre>
     */
    private Integer type;
    /**
     * ⽂字元素,当type=1 2 3 4 5 则text必填
     */
    private Text text;
    /**
     * 图⽚元素，当type=6 7 8 则img必填
     */
    private Image img;
    /**
     * 其他数据元素，当type=9 10 则data必填
     */
    private com.bxm.adx.common.sell.response.Data data;
    /**
     * 视频元素，当type=11,12则video必填
     */
    private Video video;
}
