package com.bxm.adx.common.utils;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.user.facade.DevRequest;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Arei on 2020/11/2.
 * adx（插件用）工具类
 */
public class AdxUtils {
    /**
     *
     * @param request
     * @return
     */
    // TODO: 2021/6/28  fgf注：使用UserService需要走facade调用，有点浪费资源，这里把UserService里的DevHelper搬了过来，代码有重复，可以再优化
    public static String getUidV2(BidRequest request) {
        Device device = request.getDevice();
        if (null != device) {
            return DevHelper.getUid(device);
        }
        return null;
    }
    /**
     * 从BidRequest中获取用户id
     * @param request
     * @return
     * @deprecated 不再推荐，请使用 {@link com.bxm.user.facade.service.UserService#getUser(DevRequest)}
     *
     *
     */
    @Deprecated
    public static String getUid(BidRequest request) {
        Device device = request.getDevice();
        if (null != device) {
            String imei = device.getImei();
            String imeiMD5 = device.getImei_md5();
            String idfa = device.getIdfa();
            String idfaMD5 = device.getIdfa_md5();
            String dpid = device.getDpid();
            String dpidMD5 = device.getDpid_md5();
            if (!StringUtils.isEmpty(imei)) {
                return imei;
            }
            if (!StringUtils.isEmpty(imeiMD5)) {
                return imeiMD5;
            }
            if (!StringUtils.isEmpty(idfa)) {
                return idfa;
            }
            if (!StringUtils.isEmpty(idfaMD5)) {
                return idfaMD5;
            }
            if (!StringUtils.isEmpty(dpid)) {
                return dpid;
            }
            if (!StringUtils.isEmpty(dpidMD5)) {
                return dpidMD5;
            }
            return null;
        } else {
            return null;
        }
    }


    public static String getImei(Device device) {
        if (null != device) {
            if (StringUtils.isEmpty(device.getImei())) {
                return device.getImei_md5();
            } else {
                return device.getImei();
            }
        } else {
            return null;
        }
    }

    public static String getIdfa(Device device) {
        if (null != device) {
            if (StringUtils.isEmpty(device.getIdfa())) {
                return device.getIdfa_md5();
            } else {
                return device.getIdfa();
            }
        } else {
            return null;
        }
    }

    public static Map<String, Integer> getPositionSize(String positionSize) {
        String[] split = positionSize.split("\\*");
        Map<String, Integer> sizeMap = new HashMap<>();
        if (split.length == 2) {
            if (org.apache.commons.lang3.StringUtils.isBlank(split[0])) {
                return null;
            }
            sizeMap.put("w", Integer.valueOf(split[0]));
            sizeMap.put("h", Integer.valueOf(split[1].split("\\s+")[0]));
            return sizeMap;
        }
        if (split.length < 2) {
            return null;
        }
        sizeMap.put("w", Integer.valueOf(split[0]));
        sizeMap.put("h", Integer.valueOf(split[1]));
        return sizeMap;
    }

    public static PositionJsonConfig getJsonConfig(String jsonConfig) {
        if (StringUtils.isEmpty(jsonConfig)) {
            return null;
        }
        PositionJsonConfig positionJsonConfig = JsonHelper.convert(jsonConfig, PositionJsonConfig.class);
        return positionJsonConfig;
    }

    public static int getBucket(String devNo) {
        return Math.abs(devNo.hashCode() % 100);
    }
}
