package com.bxm.adx.common.buy.positionassembly;

import java.io.Serializable;
import java.util.Objects;

import lombok.Data;

/**
 * <p>
 * 广告位组件配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-2-20
 */
@Data
public class PositionAssembly implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 已配置
     */
    public static final int CONFIG_YES = 1;
    /**
     * 未配置
     */
    public static final int CONFIG_NO = 0;
    /**
     * 关闭
     */
    public static final int CLOSED_YES = 1;
    /**
     * 开启
     */
    public static final int CLOSED_NO = 0;

    /**
     * 广告位
     */
    private String positionId;

    /**
     * 是否配置组件：0未配置，1已配置
     */
    private Integer configFlag;

    /**
     * 是否已关闭：0为开启，1:关闭
     */
    private Integer closedFlag;

    /**
     * @return 是否开启
     */
    public boolean isEnable() {
        return Objects.equals(configFlag, CONFIG_YES) && Objects.equals(closedFlag, CLOSED_NO);
    }
}
