/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.bxm.adx.common.AdxException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);
    private final ObjectMapper objectMapper;

    public ExceptionAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<String> handleException(Exception ex) {
        if (log.isErrorEnabled()) {
            log.error("catch error", (Throwable)ex);
        }
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        HttpStatus status = HttpStatus.OK;
        if (ex instanceof AdxException) {
            AdxException adxException = (AdxException)ex;
            status = HttpStatus.resolve((int)adxException.getCode());
            if (adxException.getResult() != null) {
                objectNode.put("result", adxException.getResult());
                objectNode.put("msg", adxException.getMessage());
            }
        }
        ResponseEntity entity = new ResponseEntity((Object)objectNode, status);
        return entity;
    }
}

