/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.adapter.builder.MonitorBuilder;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.sell.response.AppMonitor;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.DpMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.ssp.resp.AppTracker;
import com.bxm.adx.common.sell.ssp.resp.DpTracker;
import com.bxm.adx.common.sell.ssp.resp.Fail;
import com.bxm.adx.common.sell.ssp.resp.VMonitor;
import com.bxm.adx.common.utils.UrlUtils;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.web.util.TextEncrypted;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class ConcreteMonitorBuilder
extends MonitorBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConcreteMonitorBuilder.class);
    private final TextEncrypted textEncrypted;
    private final DspService dspService;
    private final Fetcher fetcher;

    public ConcreteMonitorBuilder(TextEncrypted textEncrypted, DspService dspService, Fetcher fetcher) {
        this.textEncrypted = textEncrypted;
        this.dspService = dspService;
        this.fetcher = fetcher;
    }

    @Override
    public VMonitor fillVMonitor(VMonitor vm, String url, AdxCounterParam param) {
        List<String> vCloseUrls = vm.getV_close_urls();
        if (null == vCloseUrls) {
            vCloseUrls = new ArrayList<String>();
        }
        vCloseUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_CLOSED));
        vm.setV_close_urls(vCloseUrls);
        List<String> vEndUrls = vm.getV_end_urls();
        if (null == vEndUrls) {
            vEndUrls = new ArrayList<String>();
        }
        vEndUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_END));
        vm.setV_end_urls(vEndUrls);
        List<String> vHalfUrls = vm.getV_half_urls();
        if (null == vHalfUrls) {
            vHalfUrls = new ArrayList<String>();
        }
        vHalfUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_1_2));
        vm.setV_half_urls(vHalfUrls);
        List<String> vMuteUrls = vm.getV_mute_urls();
        if (null == vMuteUrls) {
            vMuteUrls = new ArrayList<String>();
        }
        vMuteUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_MUTE));
        vm.setV_mute_urls(vMuteUrls);
        List<String> vProceedUrls = vm.getV_proceed_urls();
        if (null == vProceedUrls) {
            vProceedUrls = new ArrayList<String>();
        }
        vProceedUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_PROCEED));
        vm.setV_proceed_urls(vProceedUrls);
        List<String> vQuarterUrls = vm.getV_quarter_urls();
        if (null == vQuarterUrls) {
            vQuarterUrls = new ArrayList<String>();
        }
        vQuarterUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_1_4));
        vm.setV_quarter_urls(vQuarterUrls);
        List<String> vSkipUrls = vm.getV_skip_urls();
        if (null == vSkipUrls) {
            vSkipUrls = new ArrayList<String>();
        }
        vSkipUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_SKIP));
        vm.setV_skip_urls(vSkipUrls);
        List<String> vStartUrls = vm.getV_start_urls();
        if (null == vStartUrls) {
            vStartUrls = new ArrayList<String>();
        }
        vStartUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_START));
        vm.setV_start_urls(vStartUrls);
        List<String> vSuspendUrls = vm.getV_suspend_urls();
        if (null == vSuspendUrls) {
            vSuspendUrls = new ArrayList<String>();
        }
        vSuspendUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_SUSPEND));
        vm.setV_suspend_urls(vSuspendUrls);
        List<String> vThreeQuarterUrls = vm.getV_three_quarter_urls();
        if (null == vThreeQuarterUrls) {
            vThreeQuarterUrls = new ArrayList<String>();
        }
        vThreeQuarterUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_3_4));
        vm.setV_three_quarter_urls(vThreeQuarterUrls);
        List<String> vBadNetUrls = vm.getV_bad_net_urls();
        if (null == vBadNetUrls) {
            vBadNetUrls = new ArrayList<String>();
        }
        vBadNetUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_BAD_NET));
        vm.setV_bad_net_urls(vBadNetUrls);
        List<String> vLeaveUrls = vm.getV_leave_urls();
        if (null == vLeaveUrls) {
            vLeaveUrls = new ArrayList<String>();
        }
        vLeaveUrls.add(this.replace(url, param, AdxConstants.CounterMt.V_LEAVE, this.isThatDsp(param.getDspid(), AdxConstants.CounterMt.V_LEAVE)));
        vm.setV_leave_urls(vLeaveUrls);
        return vm;
    }

    @Override
    public List<String> fillClickMonitor(List<ClickMonitor> clickMonitors, String baseUrl, AdxCounterParam param) {
        ArrayList<String> curls = null;
        if (!CollectionUtils.isEmpty(clickMonitors)) {
            curls = clickMonitors.stream().map(ClickMonitor::getClick_monitor_url).collect(Collectors.toList());
        }
        if (null == curls) {
            curls = new ArrayList<String>();
        }
        curls.add(this.replace(baseUrl, param, AdxConstants.CounterMt.CLICK, this.isThatDsp(param.getDspid(), AdxConstants.CounterMt.CLICK)));
        return curls;
    }

    @Override
    public List<String> fillImpMonitor(List<ImpMonitor> impMonitors, String baseUrl, AdxCounterParam param) {
        List<Object> iurls = null;
        if (!CollectionUtils.isEmpty(impMonitors)) {
            iurls = impMonitors.stream().map(ImpMonitor::getImp_monitor_url).collect(Collectors.toList());
        }
        if (null == iurls) {
            iurls = new ArrayList();
        }
        String iurl = this.replace(baseUrl, param, AdxConstants.CounterMt.IMP);
        iurls.add(iurl);
        return iurls;
    }

    @Override
    public DpTracker fillDpMonitor(DpMonitor dpMonitor, String baseUrl, AdxCounterParam param) {
        List<String> afUrls;
        List<String> scUrls;
        List<String> asUrls;
        DpTracker dpTracker = new DpTracker();
        List<String> list = asUrls = dpMonitor == null ? null : dpMonitor.getAwk_start_urls();
        if (null == asUrls) {
            asUrls = new ArrayList<String>();
        }
        asUrls.add(this.replace(baseUrl, param, AdxConstants.CounterMt.DP_START));
        dpTracker.setAwk_start_urls(asUrls);
        List<String> list2 = scUrls = dpMonitor == null ? null : dpMonitor.getAwk_success_urls();
        if (null == scUrls) {
            scUrls = new ArrayList<String>();
        }
        scUrls.add(this.replace(baseUrl, param, AdxConstants.CounterMt.DP_SUCCESS));
        dpTracker.setAwk_success_urls(scUrls);
        List<String> list3 = afUrls = dpMonitor == null ? null : dpMonitor.getAwk_fail_urls();
        if (null == afUrls) {
            afUrls = new ArrayList<String>();
        }
        afUrls.add(this.replace(baseUrl, param, AdxConstants.CounterMt.DP_FAIL));
        dpTracker.setAwk_fail_urls(afUrls);
        return dpTracker;
    }

    @Override
    public Fail fillFailMonitor(com.bxm.adx.common.sell.response.Fail fail, String baseUrl, AdxCounterParam param) {
        if (Objects.isNull(fail)) {
            return null;
        }
        Fail f = new Fail();
        f.setTarget_url(fail.getTarget_url());
        f.setClick_urls(Lists.newArrayList((Object[])new String[]{this.replace(baseUrl, param, AdxConstants.CounterMt.CLICK_FAIL)}));
        f.setImp_urls(Lists.newArrayList((Object[])new String[]{this.replace(baseUrl, param, AdxConstants.CounterMt.IMP_FAIL)}));
        return f;
    }

    @Override
    public AppTracker fillAppTracker(AppMonitor appMonitor, String url, AdxCounterParam param) {
        List<String> actUrls;
        List<String> sfUrls;
        List<String> ssUrls;
        List<String> dsUrls;
        List<String> dfUrls;
        AppTracker appTracker = new AppTracker();
        List<String> list = dfUrls = appMonitor == null ? null : appMonitor.getDf_urls();
        if (null == dfUrls) {
            dfUrls = new ArrayList<String>();
        }
        dfUrls.add(this.replace(url, param, AdxConstants.CounterMt.APP_D_END));
        appTracker.setDf_urls(dfUrls);
        List<String> list2 = dsUrls = appMonitor == null ? null : appMonitor.getDs_urls();
        if (null == dsUrls) {
            dsUrls = new ArrayList<String>();
        }
        dsUrls.add(this.replace(url, param, AdxConstants.CounterMt.APP_D_START));
        appTracker.setDs_urls(dsUrls);
        List<String> list3 = ssUrls = appMonitor == null ? null : appMonitor.getSs_urls();
        if (null == ssUrls) {
            ssUrls = new ArrayList<String>();
        }
        ssUrls.add(this.replace(url, param, AdxConstants.CounterMt.APP_IN_START));
        appTracker.setSs_urls(ssUrls);
        List<String> list4 = sfUrls = appMonitor == null ? null : appMonitor.getSf_urls();
        if (null == sfUrls) {
            sfUrls = new ArrayList<String>();
        }
        sfUrls.add(this.replace(url, param, AdxConstants.CounterMt.APP_IN_END));
        appTracker.setSf_urls(sfUrls);
        List<String> list5 = actUrls = appMonitor == null ? null : appMonitor.getAct_urls();
        if (null == actUrls) {
            actUrls = new ArrayList<String>();
        }
        actUrls.add(this.replace(url, param, AdxConstants.CounterMt.APP_ACT));
        appTracker.setAct_urls(actUrls);
        return appTracker;
    }

    private boolean isThatDsp(String dspId, AdxConstants.CounterMt mt) {
        Dsp dsp = this.dspService.get(Long.valueOf(dspId));
        if (dsp == null) {
            return false;
        }
        List dspCodes = null;
        switch (mt) {
            case CLICK: {
                dspCodes = this.fetcher.fetchList(CacheKeys.getClickMacroDsp(), String.class);
                break;
            }
            case V_LEAVE: {
                dspCodes = this.fetcher.fetchList(CacheKeys.getVideoMacroDsp(), String.class);
                break;
            }
            default: {
                return false;
            }
        }
        if (CollectionUtils.isEmpty((Collection)dspCodes)) {
            return true;
        }
        return dspCodes.contains(dsp.getDspCode());
    }

    private String replace(String url, AdxCounterParam param, AdxConstants.CounterMt mt) {
        if (mt == null) {
            if (log.isErrorEnabled()) {
                log.error("mt is null");
            }
        } else {
            param.setMt(mt.getMt());
        }
        param.setTimestamp(System.currentTimeMillis() + "");
        if (log.isDebugEnabled()) {
            log.debug(UrlUtils.splicingCounterUrl(url, param));
        }
        return this.textEncrypted.genGetUrl(Integer.valueOf(2), UUIDHelper.generate(), UrlUtils.splicingCounterUrl(url, param));
    }

    private String replace(String url, AdxCounterParam param, AdxConstants.CounterMt mt, boolean isThatDsp) {
        if (mt == null) {
            if (log.isErrorEnabled()) {
                log.error("mt is null");
            }
        } else {
            param.setMt(mt.getMt());
        }
        param.setTimestamp(System.currentTimeMillis() + "");
        if (log.isDebugEnabled()) {
            log.debug(UrlUtils.splicingCounterUrl(url, param));
        }
        String result = this.textEncrypted.genGetUrl(Integer.valueOf(2), UUIDHelper.generate(), UrlUtils.splicingCounterUrl(url, param));
        if (isThatDsp) {
            switch (mt) {
                case CLICK: {
                    return UriComponentsBuilder.fromUriString((String)result).query(param.getClickUnEncodeParam()).build().toString();
                }
                case V_LEAVE: {
                    return UriComponentsBuilder.fromUriString((String)result).query(param.getVideoUnEncodeParam()).build().toString();
                }
            }
            return result;
        }
        return result;
    }
}

