/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.buyer;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.buyer.AbstractBuyer;
import com.bxm.adx.common.buy.buyer.HttpClientBuilder;
import com.bxm.adx.common.buy.buyer.RequestBodyCodec;
import com.bxm.adx.common.buy.dsp.Dsp;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHttpBuyer
extends AbstractBuyer {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpBuyer.class);
    private final AdxProperties properties;
    private HttpClientBuilder httpClientBuilder;

    public AbstractHttpBuyer(AdxProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHttpBuyer that = (AbstractHttpBuyer)o;
        String code = this.getCode();
        return Objects.equals(code, that.getCode());
    }

    public int hashCode() {
        return Objects.hash(this.getCode());
    }

    protected String getUri() {
        Dsp dsp = this.getDsp();
        return dsp.getApiUrl();
    }

    protected Map<String, String> getHeaders() {
        return null;
    }

    protected Method getMethod() {
        return Method.POST;
    }

    @Override
    protected byte[] request(byte[] requestBody) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            String uri = this.getUri();
            if (StringUtils.isBlank((String)uri)) {
                throw new NullPointerException("uri");
            }
            Map<String, String> headers = this.getHeaders();
            Object request = this.getMethod() == Method.GET ? this.buildGet(uri, headers, RequestBodyCodec.convert(requestBody)) : this.buildPost(uri, headers, requestBody);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                return null;
            }
            return EntityUtils.toByteArray((HttpEntity)httpEntity);
        }
        catch (SocketTimeoutException e) {
            this.buyerMeter.increaseReadException(this);
            log.debug("request: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            this.buyerMeter.increaseConnectException(this);
            log.debug("request: {}", (Object)e.getMessage());
        }
        catch (NullPointerException e) {
            log.info("request: ", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("request: ", (Throwable)e);
        }
        return null;
    }

    protected HttpClient buildHttpClient() {
        return this.httpClientBuilder.build(this.getDsp());
    }

    protected HttpGet buildGet(String uri, Map<String, String> headers, Map<String, Object> params) {
        HttpGet get = new HttpGet(this.appendParameterToUrl(params, uri));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                get.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return get;
    }

    protected HttpPost buildPost(String uri, Map<String, String> headers, byte[] requestBody) {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new ByteArrayEntity(requestBody));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return post;
    }

    protected String appendParameterToUrl(Map<String, Object> params, String url) {
        StringBuilder uri = new StringBuilder(255);
        if (!StringUtils.endsWith((String)url, (String)"?")) {
            uri.append("?");
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!StringUtils.isNotBlank((String)key) || !Objects.nonNull(value)) continue;
            uri.append(key).append("=").append(value).append("&");
        }
        url = url + StringUtils.removeEnd((String)uri.toString(), (String)"&");
        return url;
    }

    @Autowired
    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    public static enum Method {
        GET,
        POST;

    }
}

