/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.buyers;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.AbstractPluginBuyersImpl;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class DispatcherPluginBuyersImpl
extends AbstractPluginBuyersImpl {
    private DispatcherService dispatcherService;
    private final AdxProperties properties;

    protected DispatcherPluginBuyersImpl(PluginHolder pluginHolder, AdxProperties properties) {
        super(pluginHolder);
        this.properties = properties;
    }

    @Override
    public List<List<Buyer>> findAsPriority(Position position) {
        Integer maxPriority;
        Set<Integer> keys;
        String positionId = position.getPositionId();
        Map<Integer, Collection<Dsp>> dsps = this.dispatcherService.getPriority(positionId);
        Integer initSize = this.properties.getMaxCapacityOfBuyers();
        if (!MapUtils.isEmpty(dsps) && !CollectionUtils.isEmpty(keys = dsps.keySet()) && (maxPriority = (Integer)keys.stream().max(Integer::compareTo).get()) != null && maxPriority.compareTo(initSize) == 1) {
            initSize = maxPriority;
        }
        List<List<Buyer>> list = this.emptyListWithCapacity(initSize);
        Map<String, Buyer> buyers = this.getAllBuyers();
        for (Map.Entry<Integer, Collection<Dsp>> entry : dsps.entrySet()) {
            ArrayList buyerList;
            Integer priority = entry.getKey();
            Collection<Dsp> value = entry.getValue();
            int index = priority - 1;
            List<Object> list2 = CollectionUtils.isEmpty(list) ? null : (buyerList = list.size() > index ? list.get(index) : null);
            if (null == buyerList) {
                buyerList = Lists.newArrayList();
                list.add(index, buyerList);
            }
            for (Dsp dsp : value) {
                String dspCode = dsp.getDspCode();
                Buyer buyer = buyers.get(dspCode);
                if (null == buyer) continue;
                buyerList.add(buyer);
            }
        }
        list.removeIf(List::isEmpty);
        return list;
    }

    private List<List<Buyer>> emptyListWithCapacity(int size) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(Lists.newArrayList());
        }
        return list;
    }

    @Autowired
    public void setDispatcherService(DispatcherService dispatcherService) {
        this.dispatcherService = dispatcherService;
    }
}

