/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherAB;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.mccms.facade.model.pushable.DispatcherDspCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
public class DispatcherServiceImpl
implements DispatcherService {
    private static final Logger log = LoggerFactory.getLogger(DispatcherServiceImpl.class);
    private final DispatcherDao dispatcherDao;
    private final DspService dspService;
    private final DispatcherAB dispatcherAB;
    private final Fetcher fetcher;
    private final Updater updater;

    public DispatcherServiceImpl(DispatcherDao dispatcherDao, DspService dspService, DispatcherAB dispatcherAB, Fetcher fetcher, Updater updater) {
        this.dispatcherDao = dispatcherDao;
        this.dspService = dspService;
        this.dispatcherAB = dispatcherAB;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public Map<Integer, Collection<Dsp>> getPriority(String positionId) {
        Collection<DispatcherDspCacheVO> dispatchers = this.filterDispatcher(positionId);
        TreeMap dsps = Maps.newTreeMap();
        if (CollectionUtils.isEmpty(dispatchers)) {
            return dsps;
        }
        for (DispatcherDspCacheVO dispatcher : dispatchers) {
            if (dispatcher.getOpened() == 0) continue;
            int priority = dispatcher.getPriority();
            Long dspId = dispatcher.getDspId();
            Dsp dsp = this.dspService.get(dspId);
            if (null == dsp) continue;
            Collection collection = MapHelper.get(dsps, Integer.valueOf(priority), new ArrayList());
            collection.add(dsp);
        }
        return dsps;
    }

    @Override
    public Collection<Dispatcher> get(String positionId) {
        return this.dispatcherDao.get(positionId);
    }

    @Override
    public Dispatcher getByAppPosId(String appPosId, String dspCode) {
        return this.dispatcherDao.getByAppPosId(appPosId, dspCode);
    }

    @Override
    public Dispatcher get(String positionId, String dspId) {
        return this.dispatcherDao.get(positionId, dspId);
    }

    private Collection<DispatcherDspCacheVO> filterDispatcher(String positionId) {
        String uid = AdxContextFactory.get().getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            uid = RandomStringUtils.randomAlphabetic((int)13);
        }
        int userBucket = AdxUtils.getBucket(uid);
        if (log.isDebugEnabled()) {
            log.debug("userBucket = {}", (Object)userBucket);
        }
        Long configId = this.dispatcherAB.getConfigId(positionId, userBucket);
        Collection<Object> dspCacheVOS = null;
        if (Objects.isNull(configId)) {
            Collection<Dispatcher> ds = this.dispatcherDao.get(positionId);
            dspCacheVOS = new ArrayList();
            if (CollectionUtils.isEmpty(ds)) {
                if (log.isWarnEnabled()) {
                    log.warn("posid = {}, dispatcher is null", (Object)positionId);
                }
            } else {
                for (Dispatcher dispatcher : ds) {
                    DispatcherDspCacheVO dspCacheVO = new DispatcherDspCacheVO();
                    BeanUtils.copyProperties((Object)dispatcher, (Object)dspCacheVO);
                    dspCacheVO.setOpened(dispatcher.getOpened());
                    dspCacheVOS.add(dspCacheVO);
                }
            }
        } else {
            AdxContextFactory.get().setConfigId(configId);
            dspCacheVOS = this.fetcher.hfetchList(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId), uid, DispatcherDspCacheVO.class);
            if (CollectionUtils.isEmpty(dspCacheVOS)) {
                dspCacheVOS = this.dispatcherDao.getDispatchersByConfigId(positionId, configId);
            }
            dspCacheVOS = this.reorder(dspCacheVOS, uid);
            LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
            this.updater.hupdate(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId), uid, dspCacheVOS, (int)seconds);
        }
        return dspCacheVOS;
    }

    private int getPositionDspFreq(DispatcherDspCacheVO cacheVO, String uid) {
        KeyGenerator keyGenerator = this.getFreqKeyGenerator(cacheVO, uid);
        Long freq = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(freq) ? 0 : freq.intValue();
    }

    private void resetPositionDspFreq(DispatcherDspCacheVO cacheVO, String uid) {
        KeyGenerator keyGenerator = this.getFreqKeyGenerator(cacheVO, uid);
        this.updater.update(keyGenerator, (Object)0);
    }

    private KeyGenerator getFreqKeyGenerator(DispatcherDspCacheVO cacheVO, String uid) {
        return AdxKeyGenerator.Counter.getPositionDspFrequency((String)cacheVO.getPositionId(), (String)cacheVO.getConfigId().toString(), (String)cacheVO.getDspId().toString(), (String)uid);
    }

    private Collection<DispatcherDspCacheVO> reorder(Collection<DispatcherDspCacheVO> ds, String uid) {
        ArrayList<DispatcherDspCacheVO> result = new ArrayList<DispatcherDspCacheVO>();
        List ps = ds.stream().map(DispatcherDspCacheVO::getPriority).sorted().distinct().collect(Collectors.toList());
        Integer max = (Integer)ps.get(ps.size() - 1);
        for (Integer p : ps) {
            List dspCacheVOS = ds.stream().filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getPriority() == p.intValue()).filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getOpened() == 1).collect(Collectors.toList());
            if (dspCacheVOS.size() == 1) {
                Integer used;
                DispatcherDspCacheVO dc = (DispatcherDspCacheVO)dspCacheVOS.iterator().next();
                Integer initFreq = dc.getFrequency();
                if (null != initFreq && (used = Integer.valueOf(this.getPositionDspFreq(dc, uid))) >= initFreq) {
                    if (dc.getPriority() != max.intValue()) {
                        max = max + 1;
                        dc.setPriority(max.intValue());
                    }
                    this.resetPositionDspFreq(dc, uid);
                }
                result.add(dc);
                continue;
            }
            result.addAll(dspCacheVOS);
        }
        return result;
    }
}

